#/*
# *  Copyright 2007-2009 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: EbiTV.pm 1827 2009-04-08 15:24:43Z hikarin $
#

package Img0ch::Plugin::Rewrite::StreamService::EbiTV;

use strict;

sub new {
    my ( $iClass, $iBBS ) = @_;
    my $iConfig = $iBBS->get_kernel()->get_config();

    bless [
        ( $iConfig->get_int('ebitv.width')  || 540 ),
        ( $iConfig->get_int('ebitv.height') || 467 ),
        ( $iConfig->get('EnableXHTMLBreak') ? '<br />' : '<br>' ),
    ], $iClass;
}

sub from_bbs {
    my ( $iObject, $key, $count, $resno, $text ) = @_;
    my ( $width, $height, $break )
        = ( $iObject->[0], $iObject->[1], $iObject->[2] );

    $$text =~ s{
        (?:\<a[^>]+>)?
        http://w?w?w?\.?ebitv\.jp/video\.php\?id=(\d+)
        (?:\</a>)?
        }
        {<iframe src="http://www.ebitv.jp/video_frame.php?id=$1"
  width="${width}" height="${height}" frameborder="0"
  marginwidth="0" marginheight="0" scrolling="no">
</iframe>${break}}gxms;
    return;
}

*from_read = \&from_bbs;

1;
__END__
