#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: meta.pm 1481 2007-10-24 14:13:30Z hikarin $
#

package Zeromin2::App::meta;

use strict;
use Zeromin::Metadata qw();

sub load_header { _load( 'head', @_ ) }

sub load_meta { _load( 'meta', @_ ) }

sub load_footer { _load( 'foot', @_ ) }

sub load_thread_end {
    my ($zApp) = @_;
    $zApp->privilege( 'can_enter_meta_section', 1 )
        or return $zApp->return_value(1);

    my $zBBS  = $zApp->bbs();
    my $zUser = $zApp->user();
    my @data  = split '<>', Zeromin::Metadata->new($zBBS)->thread_end_utf8();
    my $message = $data[3] || '';
    $message =~ s/<br>/\n/gxms;
    $message =~ s/\s+\n\s+/\n/gxms;
    $message =~ s/\A\s+//xms;
    $message =~ s/\s+\z//xms;
    $message =~ s/\n+\z//xms;

    require Img0ch::Setting;
    my $iSetting = Img0ch::Setting->new($zBBS);

    $zApp->add_template_param(
        {   BBS_SUBTITLE   => $iSetting->get_utf8('BBS_SUBTITLE'),
            BBS_TITLE      => $iSetting->get_utf8('BBS_TITLE'),
            BBS_TYPE_THEME => $iSetting->get('BBS_TYPE_THEME'),
            Date           => $data[2],
            IsTypeTemplate =>
                ( $iSetting->get('BBS_TEMPLATE') =~ /\Atype/xms ? 1 : 0 ),
            Mail    => $data[1],
            Message => $message,
            Name    => $data[0]
        }
    );
    $zApp->return_value(0);
}

sub _load {
    my ( $method, $zApp ) = @_;
    $zApp->privilege( 'can_enter_meta_section', 1 )
        or return $zApp->return_value(1);

    my $zBBS  = $zApp->bbs();
    my $zUser = $zApp->user();
    $method .= '_utf8';

    my $iSetting = $zBBS->get_setting_instance();
    my $data     = Zeromin::Metadata->new($zBBS)->$method;
    $data =~ s/\s+\n\s+/\n/gxms;
    $data =~ s/\A\s+//xms;
    $data =~ s/\s+\z//xms;
    $data =~ s/\n+\z//xms;

    $zApp->add_template_param(
        {   BBS_SUBTITLE   => $iSetting->get_utf8('BBS_SUBTITLE'),
            BBS_TITLE      => $iSetting->get_utf8('BBS_TITLE'),
            BBS_TYPE_THEME => $iSetting->get('BBS_TYPE_THEME'),
            Data           => $data,
            IsTypeTemplate =>
                ( $iSetting->get('BBS_TEMPLATE') =~ /\Atype/xms ? 1 : 0 )
        }
    );
    $zApp->return_value(0);
}

sub save_header { _save_meta( 'head', 'can_edit_head', @_ ) }

sub save_meta { _save_meta( 'meta', 'can_edit_meta', @_ ) }

sub save_footer { _save_meta( 'foot', 'can_edit_meta', @_ ) }

sub save_thread_end {
    my ($zApp) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( 'can_edit_head', 1 ) or return $zApp->return_value(1);

    my $iKernel  = $zApp->kernel();
    my $iRequest = $zApp->request();
    my $date     = $iRequest->param('date');
    $date =~ /\AOver\s+\d+\s+Thread\z/xms or return $zApp->return_value(2);

    my $from
        = $iKernel->get_encoded_str( $iRequest->param( 'FROM', 1 ), 'utf8' );
    my $mail = $iKernel->get_encoded_str( $iRequest->param('mail'), 'utf8' );
    my $text = $iKernel->get_encoded_str( $iRequest->param( 'MESSAGE', 1 ),
        'utf8' );
    $text =~ s/\r\n/\n/gxms;
    $text =~ s/\n/<br>/gxms;

    my $content = join '<>', $from, $mail, $date, $text, '';
    Zeromin::Metadata->new( $zApp->bbs() )->thread_end( \$content );

    $zApp->logger( 1, 'MODIFIED META DATA: %s', ['thread_end'] );
    return $zApp->return_value(0);
}

sub _save_meta {
    my ( $method, $privilege, $zApp ) = @_;
    $zApp->check_csrf() or return $zApp->return_value(1);
    $zApp->privilege( $privilege, 1 ) or return $zApp->return_value(1);

    my $text
        = $zApp->kernel()
        ->get_encoded_str( $zApp->request()->param( 'content', 1 ),
        undef, 'utf8' );
    $text =~ s/\r\n/\n/gxms;

    Zeromin::Metadata->new( $zApp->bbs() )->$method( \$text );
    $zApp->logger( 1, 'MODIFIED META DATA: %s', [$method] );

    return $zApp->return_value(0);
}

1;
__END__
