#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: BBS.pm 733 2007-06-01 13:32:27Z hikarin $
#

package Img0ch::Compat::BBS;

use strict;

sub update {
    my ( $iRepos, $bbs_dir ) = @_;
    $bbs_dir or return 0;
    $bbs_dir eq 'test' or return 0;

    if ( !$iRepos->get_int("I:B.d.${bbs_dir}") ) {
        my $bbs_id = $iRepos->get_int('I:B._') + 1;
        $iRepos->set( "I:B.d.${bbs_dir}", $bbs_id );
        $iRepos->set( "I:B.i.${bbs_id}",  $bbs_dir );
        $iRepos->set( 'I:B._',            $bbs_id );
        $iRepos->save();
    }

    return 1;
}

1;
__END__
