/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Upload
 * $Id: upload.js 1425 2007-10-18 13:19:34Z hikarin $
 *
 * @require jquery.js
 * @require img0ch/app.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.Upload = function(app) {
    var path_    = app.getBBSURI() + "/img/" + app.getKey();
    var csv_     = path_ + "/upload.csv";
    var content_ = {};

    return {
        "get": function(resno) {
            var ret = content_[resno];
            return ret ? ret : [ 0, '', '', 0, 0, 0, 0 ];
        },
        "getCSVPath": function() { return csv_ },
        "getPath": function() { return path_ },
        "request": function() {
            var xml = jQuery.ajax({
                "async": false,
                "dataType": "text",
                "ifModified": true,
                "global": false,
                "type": "GET",
                "url": csv_
            });
            if ( xml.status == 200 ) {
                var lines = xml.responseText.split("\n");
                for ( var i in lines ) {
                    var chunk = lines[i].split(',');
                    content_[chunk[0]] = [ chunk[1], chunk[2],
                        chunk[3], chunk[4], chunk[5], chunk[6] ];
                }
            }
            return;
        }
    };
};
