/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * $Id: image.js 1487 2007-10-25 13:06:55Z hikarin $
 *
 * @require img0ch/app/read.js
 * @require img0ch/upload.js
 */

(function(){
    var key_ = app.getKey();
    var re_  = new RegExp(/^.[^\(]+\((.[^\)]+)\)<br\s?\/?>/);
    var ufm_ = app.getCGIURI() + "/img0ch-ufm.cgi/"
        + app.getBBS() + "/" + app.getKey() + "/";
    var re1_ = /^.[^\(]+\(.[^\)]+\)<br\s?\/?>/;
    var re2_ =  /^.[^\(]+\(.[^\)]+\)<br\s?\/?>/;
    var upload_, path_;

    app.require(
        [
            { "Img0ch.Upload": app.getStaticURI() + "/js/img0ch/upload.js" }
        ],
        function(){
            upload_ = new Img0ch.Upload(app);
            path_   = upload_.getPath();
            upload_.request();
            Img0ch.App.Read.Plugin.Image = {
                "reload": function() {
                     upload_.request();
                     return;
                },
                "rewrite": function( resno, comment ) {
                    var info = upload_.get(resno);
                    if (info[0]) {
                        var extension   = info[0];
                        var thumbWidth  = info[4];
                        var thumbHeight = info[5];
                        var file        = path_ + '/' + resno + '.' + extension;
                        if ( thumbWidth > 0 && thumbHeight > 0
                            && re_.test(comment) ) {
                            var imageWidth  = info[2];
                            var imageHeight = info[3];
                            var info = RegExp.$1;
                            var thumb = path_ + "/t" + resno + '.' + extension;
                            comment = comment.replace( re1_, "<a href=" + file + " class=i0_image><img src=" + thumb + " width=" + thumbWidth + " height=" + thumbHeight + " class=image></a>(" + info + ")<a href=" + ufm_ + resno + " onclick='Img0ch.App.removeFile(this," + key_ + "," + resno + ");return false'>[削除]</a><br>" );
                        }
                        else if (re_.test(comment)) {
                            var info = RegExp.$1;
                            comment = comment.replace( re2_, "<a href=" + file + " class=i0_file><b>[" + extension + "]</b></a>(" + info + ")<a href=" + ufm_ + resno + " onclick='Img0ch.App.removeFile(this," + key_ + "," + resno + ");return false'>[削除]</a><br>" );
                        }
                        comment += "<br class=clear>";
                    }
                    return comment;
                },
                "rendered": function() {
                    var openImage = function(e) {
                        window.open(this.href);
                        e.preventDefault();
                        return false;
                    };
                    jQuery("a.i0_image").click(openImage).keypress(openImage);
                },
            };
        }
    );
})();
