#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
package Img0ch::Plugin::BBS::Coloring;

use strict;

sub name {
    my ($iApp) = @_;
    my $name = $iApp->get_name();

    if ( $name =~ s/\A\@([0-9A-Fa-f]{6,6})\@//xms ) {
        $iApp->set_name(
            '<span style="color:#' . lc($1) . '">' . $name . '</span>' );
        return 1;
    }

    my @result = split /[rR][gG][bB]\((.+?)\)/xms, $name;
    @result == 1 and return 1;
    shift @result;
    my $new_name = '';
    for ( my $i = 0; $i < $#result; $i += 2 ) {
        my ( $color, $name ) = ( $result[$i], $result[ $i + 1 ] );
        if ( $color =~ /\A(\d+),(\d+),(\d+)\z/xms ) {
            my ( $red, $green, $blue ) = ( $1, $2, $3 );
            $red > 255   and $red   = 255;
            $green > 255 and $green = 255;
            $blue > 255  and $blue  = 255;
            my $color_hex_value
                = sprintf( '#%02lx%02lx%02lx', $red, $green, $blue );
            $new_name .= '<span style="color:'
                . $color_hex_value . '">'
                . $name
                . '</span>';
        }
        elsif ( $color =~ /\A\#?([0-9A-Fa-f]{6,6})\z/xms ) {
            $color =~ tr/\#//d;
            $new_name .= '<span style="color:#'
                . lc($color) . '">'
                . $name
                . '</span>';
        }
        else {
            $new_name .= $name;
        }
    }

    $iApp->set_name($new_name);
    return 1;
}

1;
__END__
