#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Metadata.pm 363 2007-03-16 15:11:10Z hikarin $
#

package Img0ch::Compat::Metadata;

use strict;

sub load {
    my ( $iRepos, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my $bbs     = $iBBS->get_name();

    for my $file ( 'head', 'meta', 'foot' ) {
        local ( $!, *FH );
        my $path = $iBBS->path("${file}.txt");
        open *FH, "<${path}"    ## no critic
            or $iKernel->throw_io_exception($path);
        my $content = do { local $/ = undef; <FH> };
        close *FH or $iKernel->throw_io_exception($path);
        $iRepos->set_binary( "I:M.${bbs}.${file}", $content );
    }

    my $base = $iKernel->get_config()->get('BBSPath');
    my $hash = {
        'banner.main'   => 'bannerpc.cgi',
        'banner.sub'    => 'bannersub.cgi',
        'banner.mobile' => 'bannermb.cgi',
    };
    for my $key ( keys %$hash ) {
        local ( $!, *FH );
        my $path = join '/', $base, $hash->{$key};
        open *FH, "<${path}"    ## no critic
            or $iKernel->throw_io_exception($path);
        my $banner_color = <FH>;
        my $content = do { local $/ = undef; <FH> };
        close *FH or $iKernel->throw_io_exception($path);
        $iRepos->set_binary( "I:M.${key}", $content );
    }
    return 1;
}

1;
__END__
