/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.Filter.Host
 * $Id: host.js 139 2007-01-28 11:54:38Z hikarin $
 */

if ( typeof Zeromin.Filter == "undefined" ) {
    Zeromin.Filter = {};
}

Zeromin.Filter.Host = function(id, bbs) {
    this.bbsID  = id  || 0;
    this.bbsDir = bbs || '';
    this.cache  = [];
}

Zeromin.Filter.Host.prototype = {
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "getBBS": function () {
        return this.bbsID;
    },
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsID        = id;
            this.bbsDir       = bbs;
            this.cache.length = 0;
        }
        return this;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load"),
            function (storage) {
                var data = storage.read();
                var root = document.getElementById("filterHostRoot");
                $( "textarea[@name='regexp']", root ).val(data.join("\n"));
                if ( self.bbsID ) {
                    Zeromin.DOM.renderLeftMenu("leftMetaBBSLocalMenu");
                    Zeromin.DOM.toggleMenu("bbs");
                }
                else {
                    Zeromin.DOM.renderLeftMenu("leftMetaGlobalMenu");
                    Zeromin.DOM.toggleMenu("global");
                }
                Zeromin.DOM.setFunction("DENIED HOST - list");
                Zeromin.DOM.statusOK("規制ホスト一覧を表示しました");
                $(".Container", document).hide();
                $("input#bbsOnFilterHost").val(self.getBBS());
                $(root).show();
            },
            this
        );
    },
    "save": function () {
        var self     = this;
        var param    = this.toParam("save",
                           document.getElementById("filterHostRoot"));
        Zeromin.getIO().load(
            param,
            function (storage) {
                storage.writeStatus("規制ホスト情報を更新しました");
            },
            null
        );
    },
    "toParam": function (meth, query) {
        var a = (query != null) ? $(query).fastSerialize() : [];
        a.push({ "name": "C",    "value": "filter" });
        a.push({ "name": "M",    "value": meth });
        a.push({ "name": "type", "value": "host" });
        a.push({ "name": "bbs",  "value": this.bbsID });
        return a;
    }
};
