/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Zeromin.Banner
 * $Id: banner.js 79 2007-01-11 12:25:09Z hikarin $
 */

Zeromin.Banner = function(id) {
    this.bbsID = id;
    this.cache = null;
}

Zeromin.Banner.prototype = {
    "getID": function () { return this.bbsID },
    "getCache": function () { return this.cache; },
    "setCache": function (cache) {
        this.cache = cache;
        return this;
    },
    "load": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load", null, this.bbsID),
            function (storage) {
                var data = String(storage.slurp());
                var id = self.id;
/*
                switch (id) {
                    case 1:
                    default:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                    case 3:
                    $("table", document.getElementById("mainBanner")
                    ).html(data).parent().show();
                    break;
                }
*/
                $(document.getElementById("bannerContent")).val(data);
                Zeromin.DOM.renderLeftMenu("leftMetaGlobalMenu");
                Zeromin.DOM.toggleMenu("global");
                Zeromin.DOM.setFunction("BANNER - list");
                Zeromin.DOM.statusOK("告知欄一覧を表示しました", 1000);
                $(document.getElementById("bannerId")).val(id);
                $(".Container", document).hide();
                $(document.getElementById("bannerRoot")).show();
            },
            this
        );
    },
    "save": function () {
        var self = this;
        var root = document.getElementById("bannerRoot");
        Zeromin.getIO().load(
            this.toParam("save", root),
            function (storage) {
                storage.writeStatus("告知欄を更新しました", {});
            },
            null
        );
    },
    "toParam": function (meth, query, bannerId) {
        var a = (query != null) ? $(query).fastSerialize() : [];
        if ( bannerId ) a.push({ "name": "id", "value": bannerId });
        a.push({ "name": "C", "value": "banner" });
        a.push({ "name": "M", "value": meth });
        return a;
    },
    "toString": function () { this.bbsID }
};
