/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Template.Default
 * $Id: util.js 311 2007-03-03 14:10:37Z hikarin $
 *
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.Util = (function(){
    return {
    "escapeHTMLEntities": function(html) {
        return String(html).replace(
            /&/g, "&amp;" ).replace(
            /'/g, "&#39;" ).replace(
            /</g, "&lt;" ).replace(
            />/g, "&gt;" );
    },
    "intval": function(num) {
        var n = Number(num);
        return isNaN(n) ? 0 : n;
    },
    "popup": function( parentObject, element, event, readRange ) {
        var domTT_styleClass = "domTTClassic";
        var reses            = parentObject.getAll();
        var len              = reses.length;
        var content          = "<dl class='popup'>";
        var range_array      = Img0ch.Util.parseReadRange(readRange, len);
        var from             = range_array[0];
        var to               = range_array[1];
        for ( var i = from; i <= to; i++ ) {
            content += this.popupRes( parentObject, reses, i );
        }
        content += "</dl>";
        domTT_activate(element, event, "content", content, "type", "velcro");
    },
    "popupRes": function( parentObject, reses, i, key ) {
        var content = "<dt>";
        var dt = document.getElementById("rdt_" + key + "_" + i);
        var res = reses[i];
        if ( !res || !res[0] ) return "";
        if ( dt ) {
            content += dt.innerHTML;
        }
        else {
            var mail = res[1];
            if (mail) {
                content += String(i) + " ：<a href=\"mailto:" + mail
                        + "\"><b>" + res[0] + "</b></a> ：" + res[2];
            }
            else {
                content = String(i) + " ：<span class=\"ResName\"><b>"
                        + res[0] + "</b></span> ：" + res[2];
            }
        }
        content += "</dt><dd>";
        var dd = document.getElementById("rdd_" + key + "_" + i);
        if ( dd ) {
            content += parentObject.rewrite(dd.innerHTML);
        }
        else {
            content += parentObject.rewrite(res[3]) + "<br /><br />";
        }
        content += "</dd>";
        return content;
    },
    "parseQueryString": function(aURL) {
        var param = {};
        var url   = aURL || document.URL;
        var pos   = url.indexOf('?') + 1;
        if (pos) {
            var qs = url.substring( pos, url.length ).replace(/#.+/, "");
            var params = qs.split('&');
            for ( var i in params ) {
                var kv = String(params[i]).split('=');
                param[decodeURIComponent(kv[0])]
                    = this.escapeHTMLEntities(decodeURIComponent(kv[1]));
            }
        }
        return param;
    },
    "parseReadRange": function(range, len) {
        var from = 0, to = 0, first = true;
        if ( String(range).length == 0 ) {
            return [ 1, len, first ];
        }
        else if (/^l(\d+)(n)?/.test(range)) {
            first = RegExp.$2 ? false : true;
            return [ len - Number(RegExp.$1), len, first ];
        }
        else if (/^(\d*)-(\d*)(n)?$/.test(range)) {
            from  = this.intval(RegExp.$1) || 1;
            to    = this.intval(RegExp.$2) || len;
            first = RegExp.$3 ? false : true;
            if ( from > to ) {
                var temp = from;
                from = to;
                from = temp;
            }
        }
        else {
            /^(\d+)n?$/.test(range);
            from  = to = this.intval(RegExp.$1) || 1;
            first = false;
        }
        if ( to > len ) to = len;
        return [ from, to, first ];
    }
    };
})();
