/*
 *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 * Img0ch.Thread
 * $Id: thread.js 133 2007-01-25 14:02:41Z hikarin $
 *
 * @require jquery.js
 * @require domLib.js
 * @require domTT.js
 */

var Img0ch;
if ( typeof Img0ch == "undefined" ) Img0ch = {};

Img0ch.Thread = function(option) {
    var baseURL  = option.URL;
    var bbs      = option.bbs;
    var cushion  = option.cushion || "http://nun.nu/";
    var key      = option.key;
    var gz       = option.gzip;
    var opt      = option.option;
    var rootNode = option.rootNode || "threadRoot";
    var bbsURL   = baseURL + '/'    + bbs + '/';
    var getFrom  = bbsURL  + "dat/" + key + ".dat.utf8";

    if ( gz ) getFrom += ".gz";
    if ( option.reload == false ) {
        var self    = this;
        var isOpera = window.opera;
        var preventReload = function(event) {
            if ( !event ) event = window.event;
            var keyCode = event.keyCode;
            var ctrl    = event.ctrlKey;
            if ( !ctrl && keyCode == 116 ) {
                if (event.preventDefault)
                    event.preventDefault();
                return false;
            }
            else if ( !event.shiftKey && ctrl && keyCode == 82 ) {
                self.request();
                if (event.preventDefault)
                    event.preventDefault();
                return false;
            }
        }
        isOpera ? jQuery(document).keypress(preventReload)
                : jQuery(document).keydown(preventReload);
    }

    this.baseURL       = baseURL;
    this.bbsURL        = bbsURL;
    this.bbs           = bbs;
    this.key           = key;
    this.lastModified  = "Thu, 01 Jan 1970 00:00:00 GMT";
    this.length        = 0;
    this.imageLink     = new RegExp(
        "<a[^>]*>(.+/" + bbs + "/img/" + key
        + "/(\\d+)\\.([\\w\\.]+))</a>", "g" );
    this.imageLinkTo   = "<a href='$1' rel='imagebox_" + bbs + "_"
        + key + "' title='$2.$3'><b>[$3]</b></a>";
    this.isGzip        = gz;
    this.lastUpdate    = new Date();
    this.linkRegex     = new RegExp(
        "(https?://[A-Za-z0-9~/._\\?&=\\-%#\\+:;,@']+)", "g" );
    this.linkReplaceTo = "<a href='" + cushion + "$1'>$1</a>";
    this.option        = opt;
    this.popRegex      = new RegExp(
        "(<a[^>]*>)?(&gt;|&gt;&gt;|＞|＞＞)([\\d\\-]+)(</a[^>]*>)?", "g" );
    this.popReplaceTo  = "<a href='javascript:void(0)' "
        + "onmouseover='thread.popup(this, event, \"$3\")'>&gt;&gt;$3</a>";
    this.renderCB      = option.renderCallback;
    this.requestURL    = getFrom;
    this.res           = [ [ "", "", "", "", "" ] ];
    this.rootNode      = rootNode;
}

Img0ch.Thread.prototype = {
    "request": function() {
        var xhr;
        var self = this;
        var oldSubjectValue = this.getSubject();
        var onReadyStateChange = function() {
            jQuery("div#loading").hide();
            jQuery("div#reloadLinks").show();
            if ( xhr && xhr.readyState == 4 ) {
                var status = xhr.status;
                if ( status == 200 ) {
                    self.flush();
                    var lm  = xhr.getResponseHeader("Last-Modified");
                    var len = xhr.getResponseHeader("Content-Length");
                    var dat = xhr.responseText;
                    var res = dat.split("\n");
                    self.setLastModified(lm);
                    self.setLength(len);
                    for ( var i in res ) {
                        var one = res[i].split("<>");
                        self.set(i, one);
                    }
                    var datLen = self.getCount() + 1;
                    var option = self.option;
                    var range = self.parse(option, datLen);
                    self.render( range[0], range[1], true, true );
                    self.setElapsed();
                }
                else if ( status == 206 ) {
                    var lm  = xhr.getResponseHeader("Last-Modified");
                    var len = xhr.getResponseHeader("Content-Length");
                    var dat = xhr.responseText;
                    var res = dat.split("\n");
                    var startFrom = self.getCount();
                    self.setLastModified(lm);
                    self.setLength(len);
                    for ( var i in res ) {
                        var one = res[i].split("<>");
                        self.set(i, one);
                    }
                    self.render(
                        startFrom,
                        self.getCount() + 1,
                        true,
                        false
                    );
                    self.setElapsed();
                }
                else if ( status == 304 ) {
                    self.setSubject(oldSubjectValue);
                }
                else if ( status == 404 ) {
                    self.setSubject(
                        "datが存在しません。削除されたかURL間違ってますよ。");
                    self.hideForm();
                }
                else if ( status == 416 ) {
                    xhr.onreadystatechange = null;
                    xhr = null;
                    self.request();
                    return;
                }
                else {
                    self.setSubject(status + ' ' + xhr.statusText);
                    self.hideForm();
                }
                xhr.onreadystatechange = null;
                xhr = null;
            }
        };
        this.lastUpdate = new Date();
        try {
            xhr = new XMLHttpRequest();
            xhr.open("GET", this.requestURL, true);
            xhr.setRequestHeader(
                "X-Requested-With",
                "XMLHttpRequest" );
            xhr.setRequestHeader(
                "If-Modified-Since",
                this.getLastModified() );
            var len = this.getLength();
            if ( !this.isGzip && len > 0 ) {
                var from = "bytes=" + String(len) + "-";
                xhr.setRequestHeader( "Range", from );
            }
            jQuery("div#reloadLinks").hide();
            jQuery("div#loading").show();
            this.setSubject("読み込み中...");
            xhr.onreadystatechange = onReadyStateChange;
            xhr.send(null);
        } catch (e) {
            this.setSubject(e);
            this.hideForm();
        }
        return;
    },
    "getBaseURL": function() {
        return this.baseURL;
    },
    "getBBSURL": function() {
        return this.bbsURL;
    },
    "getBBS": function() {
        return this.bbs;
    },
    "getKey": function() {
        return this.key;
    },
    "getRequestURL": function() {
        return this.requestURL;
    },
    "set": function(i, res) {
        this.res[i] = res;
        return;
    },
    "get": function(i) {
        if ( i < 1 || this.res.length > i ) {
            return "";
        }
        return this.res[i];
    },
    "getCount": function() {
        return this.res.length;
    },
    "getSubject": function() {
        return this.res[0][4] || jQuery("div#threadSubject").html();
    },
    "flush": function() {
        this.res.length = 0;
        return;
    },
    "setLastModified": function(gmt) {
        this.lastModified = gmt;
        return;
    },
    "getLastModified": function() {
        return this.lastModified;
    },
    "setLength": function(length) {
        this.length = length;
        return;
    },
    "getLength": function() {
        return this.length;
    },
    "intval": function(num) {
        var n = Number(num);
        return isNaN(n) ? 0 : num;
    },
    "read": function(n) {
        var read = this.intval(n);
        var root = document.getElementById(this.rootNode);
        if (read > 0) {
            var lastNum = Number(root.lastChild.id.match(/\d+$/));
            var from = lastNum;
            var to   = lastNum + read;
            var res  = this.getCount() + 1;
            this.render( from, to, true, true );
        }
        else {
            var firstNum = Number(root.firstChild.id.match(/\d+$/));
            if (firstNum == 1) {
                var item = root.childNodes.item(2);
                if (item) {
                   firstNum = Number(item.id.match(/\d+$/));
                }
            }
            var from = firstNum + read;
            var to   = firstNum;
            this.render( from, to, true, true );
        }
    },
    "readAll": function() {
        this.render( 2, this.getCount() + 1, true, true );
    },
    "readFrom": function(readFrom, readSize) {
        this.render( readFrom, readFrom + (readSize || 100), true, true );
    },
    "readRecent": function() {
        var count = this.getCount() + 1;
        this.render( count - 50, count, true, true );
    },
    "render": function(readStart, readTo, readFirst, isReload) {
        var reses = this.res;
        var root  = document.getElementById(this.rootNode);

        if (isReload) jQuery(root).empty();
        if ( readFirst ) {
            var res = reses[0];
            this.renderRes(root, 1, res);
        }

        var count = this.res.length;
        var count2 = count + 1;
        if ( readStart < 2 ) readStart = 2;
        if ( readTo > count2 ) readTo = count2;
        for ( var i = readStart; i < readTo; i++ ) {
            var res = reses[i - 1];
            if ( typeof res[1] == "undefined" ) {
                continue;
            }
            this.renderRes(root, i, res);
        }

        var rf = document.getElementById("readFrom");
        var loop = Math.floor( count / 100 ) + 1;
        jQuery(rf).empty();
        for ( var i = 0; i < loop; i++ ) {
            var from  = ( i * 100 ) + 1;
            var to    = ( i + 1   ) * 100;
            var node  = from + '-' + to;
            var link  = document.createElement('a');
            link.href = "javascript:thread.readFrom(" + from + ", 100)";
            link.appendChild(document.createTextNode(node));
            rf.appendChild(link);
            rf.appendChild(document.createTextNode(' '));
        }
        var rl = document.getElementById("readLatest");
        rl.href = "javascript:thread.readFrom(" + count + ")";

        this.setSubject(this.getSubject());
        if ( count >= 1000 ) this.hideForm();

        /* for KTHML and Opera's DOM exception */
        try { jQuery("title").html(subj); } catch (e) { /* do nothing */ }

        var postRenderCallback = this.renderCB;
        if (postRenderCallback) postRenderCallback();

        document.getElementById("threadSize").innerHTML
            = Math.ceil(this.getLength() / 1024) + "KB";
        return;
    },
    "renderRes": function(root, i, res) {
        var dt  = document.createElement("dt");
        dt.id = "rdt_" + i;
        var mail = res[1];
        if (mail) {
            dt.innerHTML = String(i) + " ：<a href=\"mailto:"
                         + mail + "\"><b>" + res[0]
                         + "</b></a> ：" + res[2];
        }
        else {
            dt.innerHTML = String(i) + " ：<span class=\"ResName\"><b>"
                         + res[0] + "</b></span> ：" + res[2];
        }
        var dd  = document.createElement("dd");
        dd.id = "rdd_" + i;
        dd.innerHTML = this.rewrite(res[3] || "") + "<br /><br />";
        root.appendChild(dt);
        root.appendChild(dd);
    },
    "rewrite": function(comment) {
        return String(comment).replace(
                this.popRegex,
                this.popReplaceTo
            ).replace(
                this.linkRegex,
                this.linkReplaceTo
            ).replace(
                this.imageLink,
                this.imageLinkTo
            );
    },
    "parse": function(range, len) {
        var from = 0, to = 0;
        if ( String(range).length == 0 ) {
            return [ 1, len ];
        }
        else if ( /^l(\d+)/.test(range) ) {
            return [ len - Number(RegExp.$1), len ];
        }
        else if ( range.indexOf('-') >= 0 ) {
            var tempArray = range.split('-');
            from = this.intval(tempArray[0]) || 1;
            to   = this.intval(tempArray[1]) || len;
            if ( from > to ) {
                var temp = from;
                from     = to;
                from     = temp;
            }
        }
        else {
            var n = this.intval(range) || 1;
            from  = n;
            to    = n;
        }
        if ( to > len ) to = len;
        return [ from, to ];
    },
    "popup": function(element, ev, readRange) {
        var domTT_styleClass = "domTTClassic";
        var reses            = this.res;
        var len              = reses.length;
        var content          = "<dl>";
        var range_array      = this.parse(readRange, len);
        var from             = range_array[0];
        var to               = range_array[1];
        for ( var i = from; i <= to; i++ ) {
            content += "<dt>";
            var dt = document.getElementById("rdt_" + i);
            if ( dt ) {
                content += dt.innerHTML;
            }
            else {
                var res = reses[i];
                var mail = res[1];
                if (mail) {
                    content += String(i) + " ：<a href=\"mailto:" + mail
                            + "\"><b>" + res[0] + "</b></a> ：" + res[2];
                }
                else {
                    content = String(i) + " ：<span class=\"ResName\"><b>"
                            + res[0] + "</b></span> ：" + res[2];
                }
            }
            content += "</dt><dd>";
            var dd = document.getElementById("rdd_" + i);
            if ( dd ) {
                content += this.rewrite(dd.innerHTML);
            }
            else {
                content += this.rewrite(reses[i][3]) + "<br /><br />";
            }
            content += "</dd>";
        }
        content += "</dl>";
        domTT_activate(element, ev, "content", content, "type", "velcro");
    },
    "setSubject": function(subj) {
        document.getElementById("threadSubject").innerHTML = String(subj);
    },
    "hideForm": function() {
        jQuery("div#postform").hide().parent().append(
            jQuery("div#VERSION").clone());
    },
    "setElapsed": function() {
        var diffTime = new Date() - this.lastUpdate;
        jQuery("span#renderTime").html(diffTime);
    },
    "search": function() {
        var word   = jQuery("form input#quicksearch").val();
        var type   = this.intval(jQuery("select#searchType").val());
        if ( type < 0 || type > 3 ) type = 3;
        if ( word != '' ) {
            var found = 0;
            var reses = this.res;
            var words = word.split(' ');
            var wlen  = words.length;
            var root  = document.getElementById(this.rootNode);
            jQuery(root).empty();
            for ( var i in reses ) {
                var res     = reses[i];
                if ( typeof res[3] == "undefined" ) continue;
                var hit    = 0;
                var resno  = Number(i) + 1;
                var result = [ res[0], res[1], res[2], res[3] ];
                var src    = res[type];
                for ( var j in words ) {
                    var w = words[j];
                    if ( src.indexOf(w) >= 0 ) {
                        var regex   = new RegExp(w, 'g');
                        var colored = "<b class='yellow'>" + w + "</b>";
                        src = src.replace(regex, colored);
                        hit++;
                   }
                }
                if ( hit === wlen ) {
                    found++;
                    result[type] = src;
                    this.renderRes(root, resno, result);
                }
            }
            jQuery("span#searchResult").hide().html(
                 "「" + word + "」の検索結果："
                 + String(found) + "レス発見しました"
            ).show();
        }
    },
    "addSearchForm": function() {
        var timeout;
        var self       = this;
        var delay      = 1000;
        var searching  = jQuery("span#searching");
        var onKeyEvent = function () {
            clearTimeout(timeout);
            timeout = setTimeout( function () {
                searching.show();
                self.search();
                setTimeout(function () { searching.hide() }, delay / 2);
            }, delay / 2);
        }
        searching.hide();
        jQuery("form input#quicksearch").keyup(function(ev) {
            switch(ev.keyCode) {
                case 9:
                case 13:
                case 38:
                case 40:
                ev.preventDefault();
                break;
                default:
                onKeyEvent();
            }
        });
    }
}
