#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: plugin.pm 100 2007-01-16 13:52:52Z hikarin $
#

package Zeromin::App::plugin;

use strict;

sub load {
    my ($zApp) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    $zUser->can_enter_plugin_section() or return { code => 1 };

    require Img0ch::BBS;
    require Zeromin::Plugin;
    my ( $zPluginLocal, $zPluginGlobal );
    if ( my $iBBS = $zApp->bbs() ) {
        $zPluginLocal = Zeromin::Plugin->new($iBBS);
        $zPluginLocal->load();
    }
    my $zPluginGlobal = Zeromin::Plugin->new($zApp->kernel());
    $zPluginGlobal->load();

    return { code => 0, content => $zPluginGlobal->all($zPluginLocal) };
}

sub save {
    my ($zApp) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    my $iRequest = $zApp->request();
    $zUser->can_regist_plugin() or return { code => 1 };

    require Img0ch::BBS;
    require Zeromin::Plugin;
    my $zPlugin = Zeromin::Plugin->new( $zApp->bbs() || $zApp->kernel() );
    $zPlugin->load();
    my @enable     = $iRequest->param('id');
    my @plugin_ids = $iRequest->param('plugin');
    my $ret        = { enable => 0, disable => 0 };
    my %enable_seen;
    map { $enable_seen{$_} = 1 } @enable;

    for my $plugin_id (@plugin_ids) {
        if ( exists $enable_seen{$plugin_id} ) {
            $zPlugin->enable($plugin_id);
            $ret->{enable}++;
        }
        else {
            $zPlugin->disable($plugin_id);
            $ret->{disable}++;
        }
    }
    $zPlugin->save();

    return { code => 0, content => $ret };
}

sub search {
    my ($zApp) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    $zUser->can_regist_plugin() or return { code => 1 };

    require Zeromin::BBS;
    require Zeromin::Plugin;
    my $iKernel       = $zApp->kernel();
    my $zBBS          = Zeromin::BBS->new( $iKernel, { id => 0 } );
    my $zPluginGlobal = Zeromin::Plugin->new($iKernel);

    $zPluginGlobal->load();
    my $found = $zPluginGlobal->search();
    $zPluginGlobal->save();

    my $bbs_range = $zUser->get_current_user->{bbs};
    my $array     = $bbs_range
        ? $zBBS->get($bbs_range)
        : $zBBS->all();

    for my $bbs ( @{$array} ) {
        my $zPlugin = Zeromin::Plugin->new( $zApp->kernel );
        $zPlugin->set_bbs_id( $bbs->{id} );
        $zPlugin->copy($zPluginGlobal);
        $zPlugin->save();
    }

    return { code => 0, found => $found };
}

sub config {
    my ($zApp) = @_;
    my $zUser = $zApp->user() || return { code => 1 };
    $zUser->can_regist_plugin() or return { code => 1 };

    require Img0ch::BBS;
    require Zeromin::Plugin;
    my $iRequest = $zApp->request();
    my $id       = $iRequest->param('id');
    my $iBBS     = $iRequest->bbs();
    my $key      = $iRequest->param('key') || 0;
    my $zPlugin
        = Zeromin::Plugin->new( $zApp->bbs() || $zApp->kernel(), $key );
    my ( $class, $method, $type ) = $zPlugin->get_plugin($id);

    if ( $iRequest->param('type') eq 'save' ) {
        if ( $class eq '' or $method eq '' or $type eq '' ) {
            return { code => 2 };
        }
        else {
            my @key   = $iRequest->param('config');
            my $param = {};
            map { $param->{$_} = [ my @array = $iRequest->param($_) ] } @key;
            my $serialized = $zPlugin->serialize($param);
            $zPlugin->store( $id, undef, $key, $serialized );
            return { code => 0 };
        }
    }
    else {
        my $pluginConfigClass = $class . '::Config';
        if ( eval "use ${pluginConfigClass} qw(); 1" ) {
            $zPlugin->set_form($id);
            my $callback = $pluginConfigClass->register_hook();
            $callback->{render}->($zPlugin);
            return {
                code         => 0,
                html         => ${ $zPlugin->render_html() },
                javascript   => ${ $zPlugin->render_javascript() },
                rendererable => 1,
            };
        }
        else {
            return { code => 0, rendererable => 0 };
        }
    }
}

1;
__END__
