#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Setting.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Img0ch::Compat::Setting;

use strict;

sub load {
    my ( $iRepos, $iBBS ) = @_;
    my $iKernel = $iBBS->get_kernel();
    my $path    = $iBBS->path('SETTING.TXT');

    local ( $!, *FH );
    open *FH, "<${path}" ## no critic
        or $iKernel->throw_io_exception($path);
    while ( my $line = <FH> ) {
        chomp $line;
        index( $line, '=' ) >= 0 or next;
        my ( $key, $value ) = split '=', $line, 2;
        $iRepos->set( $key, $value );
    }
    close *FH or $iKernel->throw_io_exception($path);
    return 1;
}

1;
__END__
