#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: RACC.pm 104 2007-01-20 12:48:23Z hikarin $
#

package Img0ch::Plugin::Module::RACC;

use strict;

sub get {
    my ( $iClass, $remote_address, $iConfig ) = @_;
    my $ipcc = {
        'Fast'    => 'Fast',
        'MaxMind' => 'MaxMind',
        'GeoIP'   => 'MaxMind',
        'Medium'  => 'Medium',
        'Slow'    => 'Slow',
        'DNS'     => 'DNSBL',
        'DNSBL'   => 'DNSBL',
        }->{$iConfig->get('IPCountryType')} || 'Fast';

    require "IP/Country/${ipcc}.pm";
    my $class = 'IP::Country::' . $ipcc;
    my $ic = $class->new();
    if ( $ipcc eq 'MaxMind' ) {
        my $dat = $iConfig->get('GeoIPDat');
        $ic->open($dat);
    }
    return $ic->inet_atocc( $remote_address || '' );
}

sub is {
    my ( $iClass, $remote_address, $country_code, $iConfig ) = @_;
    return $iClass->get($remote_address, $iConfig) eq $country_code;
}

1;
__END__
