#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Install.pm 117 2007-01-21 14:55:55Z hikarin $
#

package Img0ch::Plugin::Install;

use strict;

sub install {
    my ($zPlugin) = @_;

    $zPlugin->install(
        {   package => 'Img0ch::Plugin::BBS::Coloring',
            methods => {
                name => 'bbs.write.pre',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::BBS::HTMLTag',
            methods => {
                parse => 'bbs.write.pre',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::BBS::RSS',
            methods => { generate_ver_10 => 'bbs.write.post', },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::BBS::UTF8Dat',
            methods => {
                sync   => 'bbs.write.post',
                remove => 'zeromin.remove.thread',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::BBS::VIP',
            methods => {
                rewrite => 'bbs.write.pre',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Filter::BanASCII',
            methods => { is_ascii_only => 'bbs.filter', },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Filter::DNSBL',
            methods => {
                check_by_bbq  => 'bbs.filter',
                check_by_bbx  => 'bbs.filter',
                check_by_dsbl => 'bbs.filter',
                by_rbl => 'bbs.filter',
                by_spamcop => 'bbs.filter',
                by_spamhaus => 'bbs.filter',
                by_blitzed => 'bbs.filter',
                by_empty => 'bbs.filter',
                by_spamlookup => 'bbs.filter',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Filter::IP',
            methods => { check => 'bbs.filter', },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Filter::JPOnly',
            methods => { check => 'bbs.filter', },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Filter::NGWord',
            methods => { check => 'bbs.filter', },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::AutoLink',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
                from_mobile => 'mobile.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::Image',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
                from_mobile => 'mobile.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::Quotation',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
                from_mobile => 'mobile.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::StreamService::EbiTV',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::StreamService::FlipClip',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::StreamService::GoogleVideo',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::StreamService::Watchme',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::StreamService::YouTube',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_read   => 'read.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Rewrite::Truncate',
            methods => {
                from_bbs    => 'bbs.rewrite',
                from_mobile => 'mobile.rewrite',
            },
        }
    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Upload::Expires',
            methods => {
                at_post_upload => 'bbs.upload.post',
                at_post_write => 'bbs.wrie.post',
            },
        }
    );
#    $zPlugin->install(
#        {   package => 'Img0ch::Plugin::Upload::Note',
#            methods => {
#                save => 'bbs.upload.post',
#            },
#        }
#    );
    $zPlugin->install(
        {   package => 'Img0ch::Plugin::Upload::Thumbnail',
            methods => {
                create => 'bbs.upload.post',
            },
        }
    );
#    $zPlugin->install(
#        {   package => 'Img0ch::Plugin::Upload::Remove',
#            methods => {
#                at_replace_res   => 'zeromin.replace.res',
#                at_erase_res     => 'zeromin.erase.res',
#                at_remove_file   => 'zeromin.remove.file',
#                at_remove_thread => 'zeromin.remove.thread',
#            },
#        }
#    );

    return 1;
}

1;
__END__
