#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: Category.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Zeromin::Compat::Category;

use strict;

sub update {
    my ( $zCategory, $iKernel ) = @_;

    require Unicode::Japanese;
    my $base    = $iKernel->get_config()->get('BBSPath');
    my $path    = $base . '/test/info/category.cgi';

    -r $path or return 0;
    local ( $!, *FH );

    open *FH, "<${path}" ## no critic
        or $iKernel->throw_io_exception($path);
    my $unijp   = Unicode::Japanese->new();
    while ( my $line = <FH> ) {
        chomp $line;
        my ( undef, $name ) = split '<>', $line;
        if ( my $cat_id = $zCategory->get_id($name) ) {
            $zCategory->set( $cat_id, $unijp->set( $name, 'sjis' )->get() );
        }
        else {
            $zCategory->add($unijp->set( $name, 'sjis' )->get());
        }
    }
    close *FH or $iKernel->throw_io_exception($path);
    $zCategory->save();

    return 1;
}

1;
__END__
