#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: log.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Zeromin::App::log;

use strict;

sub load {
    my ($zApp) = @_;
    my $zUser    = $zApp->user() || return { code => 1 };
    my $iBBS     = $zApp->bbs();
    my $iRequest = $zApp->request();
    my $type     = $iRequest->param('type');

    my ( undef, undef, undef,
        $current_day, $current_month, $current_year ) = localtime(time());
    $current_year  += 1900;
    $current_month += 1;

    if ( $type eq 'action' ) {
        $zUser->can_enter_log_section() or return { code => 1 };
        require Zeromin::Log::Action;
        my $zLogAct = Zeromin::Log::Action->new( $zApp->kernel() );
        my $by      = $iRequest->param('by');
        my ( $year, $month, $day, $content );
        if ( $by eq 'all' ) {
            $content = $zLogAct->all($zUser);
        }
        elsif ( $by eq 'month' ) {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $content
                = $zLogAct->retrive_by_month( $year, $month, $zUser );
        }
        else {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $day = $iRequest->param_int('day') || $current_day;
            $content
                = $zLogAct->retrive_by_day( $year, $month, $day, $zUser );
        }
        return {
            code    => 0,
            content => $content,
        };
    }
    if ( $type eq 'error' ) {
        $zUser->can_view_error_log() or return { code => 1 };
        require Zeromin::Log::Error;
        my $zLogErr = Zeromin::Log::Error->new( $iBBS || $zApp->kernel() );
        my $by      = $iRequest->param('by');
        my $key     = $iRequest->param('key');
        my ( $year, $month, $day, $content );
        $zLogErr->load();
        if ( $by eq 'all' ) {
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->all_in( undef, $key );
        }
        elsif ( $by eq 'month' ) {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->retrive_by_month_in(
                $year, $month, undef, $key );
        }
        else {
            $year = $iRequest->param_int('year') || $current_year;
            $month = $iRequest->param_int('month') || $current_month;
            $day = $iRequest->param_int('day') || $current_day;
            # Img0ch::BBS => bbs_dir | Img0ch::Kernel => undef
            $content = $zLogErr->retrive_by_day_in(
                $year, $month, $day, undef, $key );
        }
        return {
            code    => 0,
            content => $content,
        };
    }
    if ( $type eq 'thread' and $iBBS ) {
        $zUser->can_view_thread_log() or return { code => 1 };
        require Zeromin::Log::Thread;
        my $zLogThr = Zeromin::Log::Thread->new($iBBS);
        $zLogThr->load();
        return { code => 0, content => $zLogThr->all() };
    }
    return { code => 0, content => [] };
}

1;
__END__
