#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: DNSBL.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Img0ch::Plugin::Filter::DNSBL;

use strict;

sub check_by_bbq {
    _check_proxy( '%d.%d.%d.%d.niku.2ch.net', @_ );
}

sub check_by_bbx {
    _check_proxy( '%d.%d.%d.%d.bbx.2ch.net', @_ );
}

sub check_by_dsbl {
    _check_proxy( '%d.%d.%d.%d.list.dbsl.org', @_ );
}

sub _check_proxy {
    my ( $base, $iApp ) = @_;

    my $addr = sprintf $base, ( reverse split '\.', $iApp->get_ip() );
    $addr = gethostbyname($addr) || $iApp->get_ip_int();
    $addr = join '.', unpack( 'C*', $addr );

    if ( $addr eq '127.0.0.2' ) {
        if ( $iApp->setting()->is_checked('BBS_OVERSEA_PROXY') ) {
            $iApp->cap()->can_pass_proxy_access() and return 1;
            $iApp->set_error('DENY_FROM_PROXY_ACCESS');
            return 0;
        }
        else {
            my $name = $iApp->get_name();
            $name = '</b>[-{}@{}@{}-]<b> ' . $name;
            $iApp->set_name($name);
        }
    }
    return 1;
}

1;
__END__
