#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: BootStrap.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Img0ch::CGI::BootStrap;

use strict;
use File::Basename qw();
use Img0ch::CGI::Request qw();
use Img0ch::Config qw();
use Img0ch::Maple qw();

sub import {
    my ( $iBootstrap, $app ) = @_;
    my $iConfig = Img0ch::Config->new();
    my $path = File::Basename::dirname( $ENV{'SCRIPT_FILENAME'} || $0 );

    eval {
        $iConfig->load("$path/img0ch-config.cgi");
        my $iKernel = Img0ch::Maple->new($iConfig);
        eval "use $app qw(); 1;" or die $@;
        $app->new($iKernel)->run();
        exit(0);
    };
    if ( my $errstr = $@ ) {
        $errstr = Img0ch::Maple::escape_html_entities($errstr);
        $errstr =~ s/\n/<br>/gxms;
        $errstr =~ s/\s/&nbsp;/gxms;
        print 'Content-type: text/html', "\n\n", $errstr, "\n";
        exit(1);
    }
}

1;
__END__
