#/*
# *  Copyright 2007 hkrn <hikarin@users.sourceforge.jp>
# *
# *  Licensed under the Apache License, Version 2.0 (the "License");
# *  you may not use this file except in compliance with the License.
# *  You may obtain a copy of the License at
# *
# *      http://www.apache.org/licenses/LICENSE-2.0
# *
# *  Unless required by applicable law or agreed to in writing, software
# *  distributed under the License is distributed on an "AS IS" BASIS,
# *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# *  See the License for the specific language governing permissions and
# *  limitations under the License.
# */
#
# $Id: category.pm 60 2006-12-31 00:29:40Z hikarin $
#

package Zeromin::App::category;

use strict;
use Zeromin::Category qw();

sub load {
    my ($zApp) = @_;
    $zApp->user() or return { code => 1 };
    my $zCat = Zeromin::Category->new( $zApp->kernel() );
    $zCat->load();
    return { code => 0, content => $zCat->all() };
}

sub save {
    my ($zApp) = @_;
    my $zUser    = $zApp->user() or return { code => 1 };
    my $iRequest = $zApp->request();
    my $zCat     = Zeromin::Category->new( $zApp->kernel() );
    my $id       = $iRequest->param_int('id');
    my $name     = $iRequest->param('name');

    if ( $name eq '' ) {
        $zApp->logger( 0, 'NO CATEGORY NAME WAS SET' );
        { code => 2 };
    }
    elsif ( $name =~ /\A\d*\z/xms ) {
        $zApp->logger( 0, 'CANNNOT SET NUMBER-ONLY NAME' );
        { code => 3 };
    }
    elsif ( $zCat->is_duplicated($name) ) {
        $zApp->logger( 0, 'DUPLICATED NAME: %s', [$name] );
        { code => 4 };
    }
    elsif ( $zCat->exist($id) ) {
        $zUser->can_edit_category() or return { code => 1 };
        $zCat->load();
        my $cat = $zCat->get($id);
        $zCat->set( $id, $name );
        $zCat->save();
        $zApp->logger( 1, 'EDIT CATEGORY: %s to %s',
            [ $cat->{name}, $name ] );
        { code => 0 };
    }
    else {
        $zUser->can_add_category() or return { code => 1 };
        $zCat->load();
        $zCat->add($name);
        $zCat->save();
        $zApp->logger( 1, 'CREATE CATEGORY: %s', [$name] );
        { code => 0, id => $zCat->get_id($name) };
    }
}

sub remove {
    my ($zApp) = @_;
    my $zUser    = $zApp->user() or return { code => 1 };
    my $iRequest = $zApp->request();
    my $zCat     = Zeromin::Category->new( $zApp->kernel() );
    my $name     = $iRequest->param('name');
    my $status   = {};

    $zUser->can_remove_category() or return { code => 1 };
    $zCat->load();
    my @ids = $iRequest->param('id');

    for my $id (@ids) {
        $id = Img0ch::Kernel::intval($id);
        if ( $zCat->remove($id) ) {
            $zCat->save();
            $zApp->logger( 1, 'REMOVE CATEGORY: %s', [$name] );
            $status->{$id} = 1;
        }
        else {
            $zApp->logger( 0, 'TRIED REMOVING INEXIST CATEGORY: %s',
                [$name] );
            $status->{$id} = 0;
        }
    }
    $zCat->save();

    { code => 0, removed => $status };
}

1;
__END__
