if ( typeof Zeromin.Log == "undefined" ) {
    Zeromin.Log = {};
}

Zeromin.Log.Action = function(bbs, key) {
    if ( bbs ) {
        this.bbsID  = bbs.getID();
        this.bbsDir = bbs.getBBS();
    }
    else {
        this.bbsID  = 0;
        this.bbsDir = "";
    }
    this.loaded = false;
    this.by = "today";
}

Zeromin.Log.Action.prototype = {
    "getID": function () { this.bbsID },
    "getBBS": function () { this.bbsDir },
    "getCache": function () {},
    "setCache": function (cache) {},
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsID        = id;
            this.bbsDir       = bbs;
        }
        return this;
    },
    "setBy": function (by) {
        this.by = by;
        return this;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            [
                { "name" : "C",    "value": "log"      },
                { "name" : "M",    "value": "load"     },
                { "name" : "type", "value": "action"   },
                { "name" : "bbs",  "value": this.bbsID },
                { "name" : "by",   "value": this.by    }
            ],
            function (storage) {
                var data = storage.read() || [];
                var root = document.getElementById("logActionRoot");
                var ls   = $(document.getElementById("logActionTable")).empty();
                var user = Zeromin.getUser();
                $("ul.nav-page", root).remove();
                for ( var i in data ) {
                    var item    = data[i];
                    var tdContent = document.createElement("td");
                    tdContent.appendChild(
                        document.createTextNode(item.reason)
                    );
                    var tdUser = document.createElement("td");
                    tdUser.appendChild(
                        document.createTextNode(
                        item.user || "unknown (or system)" )
                    );
                    var tdDate = document.createElement("td");
                    tdDate.appendChild(
                        document.createTextNode(Zeromin.getDate(item.date))
                    );
                    var tdIP = document.createElement("td");
                    tdIP.appendChild(
                        document.createTextNode(item.ip)
                    );
                    var trBase = document.createElement("tr");
                    trBase.appendChild(tdContent);
                    trBase.appendChild(tdUser);
                    trBase.appendChild(tdDate);
                    trBase.appendChild(tdIP);
                    ls.append(trBase);
                    self.loaded = true;
                }
                Zeromin.DOM.makePager(ls.parent(),
                    (Zeromin.intval(entriesByPage) || 15));
                if ( this.bbsID ) {
                    Zeromin.DOM.toggleMenu("bbs");
                    Zeromin.DOM.renderLeftMenu("leftBBSLogMenu");
                }
                else {
                    Zeromin.DOM.toggleMenu("global");
                    Zeromin.DOM.renderLeftMenu("leftMetaGlobalMenu");
                }
                Zeromin.DOM.setFunction(
                    "Log - Action - " + Zeromin.getBBS().getName()
                );
                Zeromin.DOM.statusOK("行動履歴一覧を表示しました", 1000);
                $(".Container", document).hide();
                $(root).show();
            },
            this
        );
    },
    "render": function() {
    },
    "toString": function() { return this.getBBS() }
};
