if ( typeof Zeromin.Filter == "undefined" ) {
    Zeromin.Filter = {};
}

Zeromin.Filter.IP = function(id, bbs) {
    this.bbsID  = id  || 0;
    this.bbsDir = bbs || '';
    this.cache  = [];
}

Zeromin.Filter.IP.prototype = {
    "getCache": function () { return this.cache; },
    "setCache": function (cache, add) {
        add ? this.cache.push(cache) : this.cache = cache;
        return this;
    },
    "removeCache": function (data) {
        var cache = this.cache;
        var count = 0;
        for ( var removedId in data ) {
            if ( !data[removedId] ) continue;
            for ( var i in cache ) {
                if ( cache[i].ip == removedId ) {
                    this.cache.splice(i, 1);
                    count++;
                }
            }
        }
        return count;
    },
    "get": function(id) {
        var cache = this.cache;
        for ( var i in cache ) {
            var c = cache[i];
            if ( c.id == id ) {
                return c;
            }
        }
        return {
            "ip":  "",
            "ip1": "",
            "ip2": "",
            "ip3": "",
            "ip4": "",
            "bbs": ""
        };
    },
    "getBBS": function () {
        return this.bbsID;
    },
    "setBBS": function (id, bbs) {
        if ( this.bbsDir != bbs ) {
            this.bbsID        = id;
            this.bbsDir       = bbs;
            this.cache.length = 0;
        }
        return this;
    },
    "load": function (entriesByPage) {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("load"),
            function (storage) {
                var bbs  = Zeromin.getBBS();
                var data = storage.read();
                var ls   = $(document.getElementById("filterIPTable")).empty();
                for ( var i in data ) {
                    var item  = data[i];
                    var bbsID = item.bbs;
                    var tdBase = document.createElement("td");
                    tdBase.appendChild(
                        $(document.createElement("input")).attr({
                            "type" : "checkbox",
                            "name" : "id",
                            "value": item.ip
                        }).get(0)
                    );
                    var tdIP = document.createElement("td");
                    tdIP.appendChild(
                        document.createTextNode(item.ip)
                    );
                    var tdBBS = document.createElement("td");
                    tdBBS.appendChild(
                        document.createTextNode(
                            bbs.getName(bbsID) || "全ての掲示板")
                    );
                    var tdReason = document.createElement("td");
                    tdReason.appendChild(
                        document.createTextNode("")
                    );
                    var trBase = document.createElement("tr");
                    trBase.appendChild(tdBase);
                    trBase.appendChild(tdIP);
                    trBase.appendChild(tdBBS);
                    trBase.appendChild(tdReason);
                    ls.append(trBase);
                }
                Zeromin.DOM.makePager(
                    ls.parent(), 10 || entriesByPage);
                if ( self.bbsID ) {
                    Zeromin.DOM.renderLeftMenu("leftMetaBBSLocalMenu");
                    Zeromin.DOM.toggleMenu("bbs");
                }
                else {
                    Zeromin.DOM.renderLeftMenu("leftMetaGlobalMenu");
                    Zeromin.DOM.toggleMenu("global");
                }
                Zeromin.DOM.setFunction("DENY - list");
                Zeromin.DOM.statusOK("規制IP一覧を表示しました");
                $(".Container", document).hide();
                $("input#bbsOnFilterIP").val(self.getBBS());
                $(document.getElementById("filterIPRoot")).show();
            },
            this
        );
    },
    "save": function () {
        var self     = this;
        var param    = this.toParam("save",
                           document.getElementById("filterIPCreate"));
        var filterIP = Zeromin.DOM.deserialize(param);
        Zeromin.getIO().load(
            param,
            function (storage) {
                if ( storage.isReturnedSuccess() ) {
                    var ip = storage.get("id");
                    var ipArray = ip.split(".");
                    self.setCache({
                        "ip":  ip,
                        "ip1": ipArray[0],
                        "ip2": ipArray[1],
                        "ip3": ipArray[2],
                        "ip4": ipArray[3],
                        "bbs": filterIP.bbs
                    }, true);
                }
                storage.writeStatus("規制IPに登録しました", {
                    "2": "指定範囲に間違いがあります",
                    "3": "その規制IPは既に登録されています"
                });
            },
            null
        );
    },
    "remove": function () {
        var self = this;
        Zeromin.getIO().load(
            this.toParam("remove", document.getElementById("filterIPTable")),
            function (storage) {
                var removed = storage.get("removed");
                if ( removed == null ) {
                    Zeromin.DOM.statusNG("指定された処理は行われませんでした");
                }
                else {
                    var count = self.removeCache(removed);
                    Zeromin.DOM.statusOK(count + "個の規制IPを解除しました");
                }
            },
            null
        );
    },
    "toParam": function (meth, query) {
        var a = (query != null) ? $(query).fastSerialize() : [];
        a.push({ "name": "C",    "value": "filter" });
        a.push({ "name": "M",    "value": meth });
        a.push({ "name": "type", "value": "ip" });
        a.push({ "name": "bbs",  "value": this.bbsID });
        return a;
    }
};
