<?php //$id: $
/**
 * Script that displays the header frame for lp_view.php
 * @package iilearn.learnpath
 * @author Yannick Warnier <ywarnier@beeznest.org>
 */
/**
 * Script
 */

// hgz 20070704
//flag to allow for anonymous user - needs to be set before global.inc.php
$use_anonymous = true;

// name of the language file that needs to be included 
$language_file[] = "scormdocument";
// hgz 20070426 add languagefile
$language_file[] = "learnpath";
require_once('back_compat.inc.php');
require_once('learnpath.class.php');
require_once('scorm.class.php');
require_once('aicc.class.php');
if(isset($_SESSION['lpobject'])){
	$temp = $_SESSION['lpobject'];
	$_SESSION['oLP'] = unserialize($temp);
}

// hgz 20070704
$path_name = htmlspecialchars($_SESSION['oLP']->get_name());
$path_id = $_SESSION['oLP']->get_id();
// use the flag set in lp_view.php to check if this script has been loaded
// as a frame of lp_view.php. Otherwise, redirect to lp_controller
if(!isset($_SESSION['loaded_lp_view']) || $_SESSION['loaded_lp_view']==false)
{
	header('location: lp_controller.php?'.api_get_cidreq().'&action=view&item_id='.$path_id);
}
//unset the flag as it has been used already
$_SESSION['loaded_lp_view'] = false;
// Check if the learnpaths list should be accessible to the user
$show_link = true;
if(!api_is_allowed_to_edit()) //if the user has no edit permission (simple user)
{
	$course_tool_table = Database::get_course_table(TABLE_TOOL_LIST);
	$result = api_sql_query("SELECT * FROM $course_tool_table WHERE name='learnpath'",__FILE__,__LINE__);
	if(Database::num_rows($result)>0)
	{
		$row = Database::fetch_array($result);
		if($row['visibility'] == '0') //if the tool is *not* visible
		{
			$show_link = false;
		}
	}
	else
	{
		$show_link = false;
	}
}

//$nameTools = $_SESSION['oLP']->get_name();
$header_hide_main_div = true;
// hgz 20070704
if($show_link)
{
	$interbreadcrumb[]= array ("url"=>"./lp_controller.php?action=list", "name"=> get_lang(ucfirst(TOOL_LEARNPATH)));
}
else //if the tool is hidden and the user has no edit permissions, make the breadcrumb link point to the course homepage
{
	$web_course_path = api_get_path(WEB_COURSE_PATH);
	$interbreadcrumb[]= array ("url"=>$web_course_path.$_course['path'].'/index.php', "name"=> get_lang(ucfirst(TOOL_LEARNPATH)));
}
$interbreadcrumb[] = array("url"=>"./lp_controller.php?action=view&lp_id=".$path_id,'name'=>$path_name);

//$interbreadcrumb[]= array ("url"=>"./lp_controller.php?action=list", "name"=> get_lang('lang_learning_path'));
$noPHP_SELF = true;
$this_section = SECTION_COURSES;
Display::display_header($nameTools,"Path", null);
?>
</div>
</body>
</html>