<?php
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) various contributors
	Copyright (c) Bart Mollet

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
* This script shows the group space for one specific group, possibly displaying
* a list of users in the group, subscribe or unsubscribe option, tutors...
*
* @package iilearn.group
* @todo	Display error message if no group ID specified
==============================================================================
*/
/*
==============================================================================
		INIT SECTION
==============================================================================
*/
// name of the language file that needs to be included
$language_file = "group";
include ('../inc/global.inc.php');
/*
-----------------------------------------------------------
	Libraries & config files
-----------------------------------------------------------
*/
include_once (api_get_path(LIBRARY_PATH).'course.lib.php');
include_once (api_get_path(LIBRARY_PATH).'groupmanager.lib.php');
/*
==============================================================================
		MAIN CODE
==============================================================================
*/
$current_group = GroupManager :: get_group_properties($_GET['gidReq']);

$this_section = SECTION_COURSES;
$nameTools = get_lang("GroupSpace") . '(' . stripslashes($current_group['name']) . ')';
$interbreadcrumb[] = array ("url" => "group.php", "name" => get_lang("GroupManagement"));

/*
-----------------------------------------------------------
	Header
-----------------------------------------------------------
*/
Display::display_header($nameTools,"Group");

/*
-----------------------------------------------------------
	Actions and Action links
-----------------------------------------------------------
*/
/*
 * User wants to register in this group
 */
if ($_GET['selfReg'] && GroupManager :: is_self_registration_allowed($_SESSION['_uid'], $current_group['id']))
{
	GroupManager :: subscribe_users($_SESSION['_uid'], $current_group['id']);
	Display :: display_normal_message(get_lang('GroupNowMember'));
}

/*
 * User wants to unregister from this group
 */
if ($_GET['selfUnReg'] && GroupManager :: is_self_unregistration_allowed($_SESSION['_uid'], $current_group['id']))
{
	GroupManager :: unsubscribe_users($_SESSION['_uid'], $current_group['id']);
	Display::display_normal_message(get_lang('StudentDeletesHimself'));
}
/*
 * Edit the group
 */
if (api_is_allowed_to_edit() or GroupManager :: is_tutor($_user['user_id']))
{
	$html = "<a href='group_edit.php?gidReq={$current_group['id']}&origin={$origin}'>";
	$html .= Display::return_icon("edit.gif") . get_lang("EditGroup") . "</a><br/><br>";
	echo $html;
}

/*
 * Register to group
 */
if (GroupManager :: is_self_registration_allowed($_SESSION['_uid'], $current_group['id']))
{
    //sshgz 20070423
	echo '<p align="right"><a href="'.$_SERVER['PHP_SELF'].'?selfReg=1&amp;group_id='.$current_group['id'].'" onclick="javascript:if(!confirm('."'".addslashes(htmlentities(get_lang("ConfirmYourChoice"), ENT_NOQUOTES, SYSTEM_CHARSET))."'".')) return false;">'.get_lang("RegIntoGroup").'</a></p>';
}

/*
 * Unregister from group
 */
if (GroupManager :: is_self_unregistration_allowed($_SESSION['_uid'], $current_group['id']))
{
	echo '<p align="right"><a href="'.$_SERVER['PHP_SELF'].'?selfUnReg=1" onclick="javascript:if(!confirm('."'".addslashes(htmlentities(get_lang("ConfirmYourChoice"), ENT_NOQUOTES, SYSTEM_CHARSET))."'".')) return false;">'.get_lang("StudentUnsubscribe").'</a></p>';
}

if( isset($_GET['action']))
{
	switch( $_GET['action'])
	{
		case 'show_msg':
			Display::display_normal_message($_GET['msg']);
			break;
	}
}

/*
-----------------------------------------------------------
	Main Display Area
-----------------------------------------------------------
*/
$course_code = $_course['sysCode'];
$is_course_member = CourseManager :: is_user_subscribed_in_real_or_linked_course($_SESSION['_uid'], $course_code);

$html = "<div class='courseGroupSpace'>";
$html .= "<table class='contentData' cellspacing='0'>";
$html .= "<tr>";
$html .= "<th align='left'>" . Display::return_icon("star.gif") . get_lang("Tools") . "</th>";
$html .= "</tr>";

/*
 * Group Tools
 */
// If the user is subscribed to the group or the user is a tutor of the group then
if (api_is_allowed_to_edit() OR GroupManager :: is_user_in_group($_SESSION['_uid'], $current_group['id']))
{
	$html .= "<tr><td>";

	if (!is_null($current_group['forum_id']) && $current_group['forum_state'] != TOOL_NOT_AVAILABLE)
	{
		$html .= "<a href=\"../forum/viewforum.php?".api_get_cidreq()."&amp;origin=$origin&amp;gidReq=".$current_group['id']."&amp;forum=".$current_group['forum_id']."\">".Display::return_icon('forum.gif')."&nbsp;".get_lang("Forums")."</a>";
	}
	if( $current_group['doc_state'] != TOOL_NOT_AVAILABLE )
	{
		// link to the documents area of this group
		$html .= "<a style='margin-left:20px;' href='../document/document.php?" . api_get_cidreq() . "&amp;gidReq=" . $current_group['id'] . "'>" . Display::return_icon('folder_document.gif') . "&nbsp;" . get_lang("GroupDocument") . "</a>";
	}
	if ( $current_group['calendar_state'] != TOOL_NOT_AVAILABLE)
	{
		//link to a group-specific part of agenda
		$html .= "<a style='margin-left:20px;' href=\"../calendar/agenda.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."&amp;group=".$current_group['id']."&amp;acces=0\">".Display::return_icon('agenda.gif')."&nbsp;".get_lang("GroupCalendar")."</a>";
	}
	if ( $current_group['work_state'] != TOOL_NOT_AVAILABLE)
	{
		//link to the works area of this group
		$html .= "<a style='margin-left:20px;' href=\"../work/work.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."\">".Display::return_icon('works.gif')."&nbsp;".get_lang("GroupWork")."</a>";
	}
	if ( $current_group['announcements_state'] != TOOL_NOT_AVAILABLE)
	{
		//link to a group-specific part of announcements
		$html .= "<a style='margin-left:20px;' href=\"../announcements/announcements.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."\">".Display::return_icon('valves.gif')."&nbsp;".get_lang("GroupAnnouncements")."</a>";
	}
}
else
{
	$html .= "<tr><td>";

	if ($current_group['forum_state'] == TOOL_PUBLIC && !is_null($current_group['forum_id']))
	{
		$html .= "<a style='margin-left:20px;' href=\"../forum/viewforum.php?".api_get_cidreq()."&amp;origin=$origin&amp;gidReq=".$current_group['id']."&amp;forum=".$current_group['forum_id']."\">".Display::return_icon('forum.gif')."&nbsp;".get_lang("Forums")."</a>";
	}
	if( $current_group['doc_state'] == TOOL_PUBLIC )
	{
		// link to the documents area of this group
		$html .= "<a style='margin-left:20px;' href=\"../document/document.php?".api_get_cidreq()."&amp;gidReq=".$current_group['id']."&amp;origin=$origin\">".Display::return_icon('folder_document.gif')."&nbsp;".get_lang("GroupDocument")."</a>";
	}
	if ( $current_group['calendar_state'] == TOOL_PUBLIC )
	{
		//link to a group-specific part of agenda
		$html .= "<a style='margin-left:20px;' href=\"../calendar/agenda.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."&amp;group=".$current_group['id']."\">".Display::return_icon('agenda.gif')."&nbsp;".get_lang("GroupCalendar")."</a>";
	}
	if ( $current_group['work_state'] == TOOL_PUBLIC )
	{
		//link to the works area of this group
		$html .= "<a style='margin-left:20px;' href=\"../work/work.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."\">".Display::return_icon('works.gif')."&nbsp;".get_lang("GroupWork")."</a>";
	}
	if ( $current_group['announcements_state'] == TOOL_PUBLIC)
	{
		//link to a group-specific part of announcements
		$html .= "<a style='margin-left:20px;' href=\"../announcements/announcements.php?".api_get_cidreq()."&amp;toolgroup=".$current_group['id']."&amp;group=".$current_group['id']."\">".Display::return_icon('valves.gif')."&nbsp;".get_lang("GroupAnnouncements")."</a>";
	}
}

$html .= "</td></tr></table><br><br>";
echo $html;

$html = "<table class='contentData' cellspacing='0'>";
$html .= "<tr>";
$html .= "<th align='left'>" . Display::return_icon("star.gif") . get_lang("GroupTutors") . "</th>";
$html .= "</tr>";
$html .= "<tr><td>";
/*
 * list all the tutors of the current group
 */
$tutors = GroupManager::get_subscribed_tutors($current_group['id']);
if (count($tutors) == 0)
{
	$html .= get_lang("GroupNoneMasc");
}
else
{
	foreach($tutors as $index => $tutor)
	{
		$html .= "<a style='margin-left:20px;' href='../user/userInfo.php?origin=".$origin."&amp;uInfo=".$tutor['user_id']."'><img src='../img/coachs.gif' align='absbottom'>&nbsp;".$tutor['firstname']." ".$tutor['lastname']."</a>";
	}
}

$html .= "</td></tr></table><br><br>";
echo $html;


/*
 * list all the members of the current group
 */
$html = "<table class='contentData' cellspacing='0'>";
$html .= "<tr>";
$html .= "<th align='left'>" . Display::return_icon("star.gif") . get_lang("GroupMembers") . "</th>";
$html .= "</tr>";
$html .= "<tr><td>";

$tutors = GroupManager::get_subscribed_users($current_group['id']);
if (count($tutors) == 0)
{
	$html .= get_lang("GroupNoneMasc");
}
else
{
	foreach($tutors as $index => $member)
	{
		$html .= "<a style='margin-left:20px;' href='../user/userInfo.php?origin=".$origin."&amp;uInfo=".$member['user_id']."'><img src='../img/members.gif' align='absbottom'>&nbsp;".$member['firstname']." ".$member['lastname']."</a>";
	}
}

$html .= "</td></tr></table>";
$html .= "</div>";
echo $html;
/*
==============================================================================
		FOOTER
==============================================================================
*/
if ($origin != 'learnpath')
{
	Display::display_footer();
}
?>