<?php
// $Id: user_export.php 11999 2007-04-12 21:31:57Z pcool $
/*
==============================================================================
	Dokeos - elearning and course management software

	Copyright (c) 2004 Dokeos S.A.
	Copyright (c) 2003 Ghent University (UGent)
	Copyright (c) 2001 Universite catholique de Louvain (UCL)
	Copyright (c) Olivier Brouckaert
	Copyright (c) Bart Mollet, Hogeschool Gent

	For a full list of contributors, see "credits.txt".
	The full license can be read in "license.txt".

	This program is free software; you can redistribute it and/or
	modify it under the terms of the GNU General Public License
	as published by the Free Software Foundation; either version 2
	of the License, or (at your option) any later version.

	See the GNU General Public License for more details.

	Contact: Zhong 	poopsoft@163.com
==============================================================================
*/
/**
==============================================================================
*	@package iilearn.admin
==============================================================================
*/
// name of the language file that needs to be included
$language_file = 'admin';

$cidReset = true;

include ('../inc/global.inc.php');
$this_section = SECTION_PLATFORM_ADMIN;

api_protect_admin_script();
include (api_get_path(LIBRARY_PATH).'fileManage.lib.php');
include (api_get_path(LIBRARY_PATH).'export.lib.inc.php');
include (api_get_path(LIBRARY_PATH).'formvalidator/FormValidator.class.php');

// Database table definitions
$course_table 		= Database :: get_main_table(TABLE_MAIN_COURSE);
$user_table 		= Database :: get_main_table(TABLE_MAIN_USER);
$course_user_table 	= Database :: get_main_table(TABLE_MAIN_COURSE_USER);

$tool_name = get_lang('ExportUserListXMLCSV');

$interbreadcrumb[] = array ("url" => 'index.php', "name" => get_lang('PlatformAdmin'));

set_time_limit(0);

$courses = array ();
$courses[''] = get_lang('All');
$sql = "SELECT code,visual_code,title FROM $course_table ORDER BY visual_code";
$result = api_sql_query($sql, __FILE__, __LINE__);
while ($course = mysql_fetch_object($result))
{
	$courses[$course->code] = $course->visual_code.' - '.$course->title;
}

$form = new FormValidator('export_users');

$form->addElement('header', 'header', get_lang('ExportUserListXMLCSV'));

$group = array();
$group[] = $form->createElement('radio', 'file_type', null, 'Excel','xls');
$group[] = $form->createElement('radio', 'file_type', null, 'XML','xml');
$group[] = $form->createElement('radio', 'file_type', null, 'CSV','csv');
$form->addGroup($group,'file_type',get_lang('OutputFileType'),null,false);

$form->addElement('checkbox', 'addcsvheader', get_lang('AddCSVHeader'), get_lang('YesAddCSVHeader'),'1');

$encodings = array('UTF-8'=>'UTF-8','GB2312'=>'GB2312','BIG5'=>'BIG5','EUC-JP'=>'EUC-JP');
$form->addElement('select', 'export_encoding', get_lang('ExportEncoding'), $encodings);

$form->addElement('select', 'course_code', get_lang('OnlyUsersFromCourse'), $courses);

$group = array ();
$group[] = $form->createElement('submit', 'submit', get_lang('Ok'), 'class="inputSubmit"');
$form->addGroup($group, 'submit', '&nbsp;', null, false);

$form->setDefaults(array('file_type'=>'xls'));

Display::setTemplateBorder($form, '60%');

if ($form->validate())
{
	$export = $form->exportValues();
	$file_type = $export['file_type'];
	$course_code = $export['course_code'];
	$export_encoding = $export['export_encoding'];
	$sql = "SELECT  u.user_id 	AS UserId,
					u.lastname 	AS LastName,
					u.firstname 	AS FirstName,
					u.email 		AS Email,
					u.username	AS UserName,
					u.password	AS Password,
					u.auth_source	AS AuthSource,
					u.status		AS Statut,
					u.official_code	AS OfficialCode,
					u.phone		AS Phone";
	if (strlen($course_code) > 0)
	{
		$sql .= " FROM $user_table u, $course_user_table cu WHERE u.user_id = cu.user_id ORDER BY lastname,firstname";
		$filename = 'export_users_'.$course_code.'_'.date('Y-m-d_H-i-s');
	}
	else
	{
		$sql .= " FROM $user_table u ORDER BY lastname,firstname";
		$filename = 'export_users_'.date('Y-m-d_H-i-s');
	}
	$data = array();
	if ($export['addcsvheader']=='1' && ($export['file_type']=='csv' || $export['file_type']=='xls'))
	{
		$data[] = array('UserId', 'LastName', 'FirstName', 'Email', 'UserName', 'Password', 'AuthSource', 'Statut', 'OfficialCode', 'Phone');
	}
	$res = api_sql_query($sql,__FILE__,__LINE__);

	while($user = mysql_fetch_array($res,MYSQL_ASSOC))
	{
		if (strtolower($export_encoding) != strtolower(SYSTEM_CHARSET)) {
			//$user['LastName'] = mb_convert_encoding($user['LastName'], $export_encoding, SYSTEM_CHARSET);
			$user['FirstName'] = mb_convert_encoding($user['FirstName'], $export_encoding, SYSTEM_CHARSET);
		}
		$data[] = $user	;
	}
	switch($file_type)
	{
		case 'xml':
			Export::export_table_xml($data,$filename,'Contact','Contacts');
			break;
		case 'csv':
			Export::export_table_csv($data,$filename);
			break;
		case 'xls':
			Export::export_table_xls($data,$filename);
			break;
	}
}
Display :: display_header($tool_name);
//api_display_tool_title($tool_name);

$form->display();

/*
==============================================================================
		FOOTER
==============================================================================
*/
Display :: display_footer();
?>