/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.uno.bridges.java_remote;

import com.sun.star.bridge.XBridge;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.XConnection;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XEventListener;
import com.sun.star.lib.uno.bridges.java_remote.ProxyFactory;
import com.sun.star.lib.uno.bridges.java_remote.RequestHandler;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionInputStream_Adapter;
import com.sun.star.lib.uno.bridges.java_remote.XConnectionOutputStream_Adapter;
import com.sun.star.lib.uno.environments.java.java_environment;
import com.sun.star.lib.uno.environments.remote.IMessage;
import com.sun.star.lib.uno.environments.remote.IProtocol;
import com.sun.star.lib.uno.environments.remote.IReceiver;
import com.sun.star.lib.uno.environments.remote.IThreadPool;
import com.sun.star.lib.uno.environments.remote.Job;
import com.sun.star.lib.uno.environments.remote.ThreadId;
import com.sun.star.lib.uno.environments.remote.ThreadPoolManager;
import com.sun.star.lib.uno.typedesc.TypeDescription;
import com.sun.star.lib.util.DisposeListener;
import com.sun.star.lib.util.DisposeNotifier;
import com.sun.star.lib.util.IInvokable;
import com.sun.star.lib.util.IInvokeHook;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.UnoRuntime;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Vector;

public class java_remote_bridge
implements IBridge,
IReceiver,
RequestHandler,
XBridge,
XComponent,
DisposeNotifier {
    private static final boolean DEBUG = false;
    public static IInvokeHook __MessageDispatcher_run_hook;
    protected XConnection _xConnection;
    protected InputStream _inputStream;
    protected DataOutputStream _outputStream;
    protected XInstanceProvider _xInstanceProvider;
    protected String _name;
    protected IProtocol _iProtocol;
    protected IEnvironment _java_environment;
    protected MessageDispatcher _messageDispatcher;
    protected int _life_count;
    protected Vector _listeners;
    protected boolean _negotiate;
    protected boolean _forceSynchronous;
    protected IThreadPool _iThreadPool;
    private boolean disposed;
    private final HashMap refHolders;
    private final ProxyFactory proxyFactory;
    private final ArrayList disposeListeners;

    private /* synthetic */ void finit$() {
        this._name = "remote";
        this._life_count = 0;
        this._forceSynchronous = true;
        this.disposed = false;
        this.refHolders = new HashMap();
        this.disposeListeners = new ArrayList();
    }

    int getLifeCount() {
        return this._life_count;
    }

    IProtocol getProtocol() {
        return this._iProtocol;
    }

    private boolean hasRefHolder(String string, Type type) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            block4: {
                try {
                    LinkedList linkedList = (LinkedList)this.refHolders.get(string);
                    if (linkedList == null) break block4;
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        RefHolder refHolder = (RefHolder)iterator.next();
                        if (!type.isSupertypeOf(refHolder.getType())) continue;
                        boolean bl = true;
                        Object var8_9 = null;
                        return bl;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_11 = null;
                    throw throwable;
                }
            }
            Object var8_10 = null;
        }
        boolean bl = false;
        return bl;
    }

    final void addRefHolder(Object object, Type type, String string) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            LinkedList<RefHolder> linkedList;
            block5: {
                try {
                    linkedList = (LinkedList<RefHolder>)this.refHolders.get(string);
                    if (linkedList == null) {
                        linkedList = new LinkedList<RefHolder>();
                        this.refHolders.put(string, linkedList);
                    }
                    boolean bl = false;
                    Iterator iterator = linkedList.iterator();
                    while (!bl && iterator.hasNext()) {
                        RefHolder refHolder = (RefHolder)iterator.next();
                        if (!refHolder.getType().equals(type)) continue;
                        bl = true;
                        refHolder.acquire();
                    }
                    if (bl) break block5;
                    linkedList.add(new RefHolder(type, object));
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
            linkedList = null;
        }
        this.acquire();
    }

    final void remRefHolder(Type type, String string) {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            try {
                Object var7_7;
                LinkedList linkedList = (LinkedList)this.refHolders.get(string);
                if (linkedList != null) {
                    Iterator iterator = linkedList.iterator();
                    while (iterator.hasNext()) {
                        block7: {
                            RefHolder refHolder = (RefHolder)iterator.next();
                            if (!refHolder.getType().equals(type)) continue;
                            try {
                                if (!refHolder.release()) break block7;
                                linkedList.remove(refHolder);
                                if (!linkedList.isEmpty()) break block7;
                                this.refHolders.remove(string);
                            }
                            catch (Throwable throwable) {
                                Object var7_8 = null;
                                this.release();
                                throw throwable;
                            }
                        }
                        var7_7 = null;
                        this.release();
                        break;
                    }
                }
                var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                throw throwable;
            }
        }
    }

    final void freeHolders() {
        HashMap hashMap = this.refHolders;
        synchronized (hashMap) {
            Iterator iterator;
            try {
                iterator = this.refHolders.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    LinkedList linkedList = (LinkedList)entry.getValue();
                    Iterator iterator2 = linkedList.iterator();
                    while (iterator2.hasNext()) {
                        RefHolder refHolder = (RefHolder)iterator2.next();
                        boolean bl = false;
                        while (!bl) {
                            bl = refHolder.release();
                            this._java_environment.revokeInterface(string, refHolder.getType());
                            this.release();
                        }
                    }
                }
                this.refHolders.clear();
            }
            finally {
                iterator = null;
            }
            return;
        }
    }

    private String parseAttributes(String string) {
        string = string.trim().toLowerCase();
        String string2 = null;
        int n = string.indexOf(44);
        if (n >= 0) {
            string2 = string.substring(0, n);
            string = string.substring(n + 1).trim();
        } else {
            string2 = string;
            string = "";
        }
        string2 = string2.trim();
        boolean bl = false;
        while (string.length() > 0) {
            n = string.indexOf(44);
            String string3 = null;
            if (n >= 0) {
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1).trim();
            } else {
                string3 = string.trim();
                string = "";
            }
            String string4 = null;
            String string5 = null;
            n = string3.indexOf(61);
            if (n >= 0) {
                string4 = string3.substring(0, n).trim();
                string5 = string3.substring(n + 1).trim();
            } else {
                string4 = string3;
            }
            if (string4.equals("negotiate")) {
                this._negotiate = string5 != null ? Integer.parseInt(string5) == 1 : true;
                bl = true;
                continue;
            }
            if (string4.equals("forcesynchronous")) {
                this._forceSynchronous = string5 != null ? Integer.parseInt(string5) == 1 : true;
                if (!this._forceSynchronous || bl) continue;
                this._negotiate = true;
                continue;
            }
            System.err.println(this.getClass().getName() + ".<init> - unknown attribute:" + string4);
        }
        if (this._negotiate) {
            throw new com.sun.star.uno.RuntimeException("java_remote_bridge: negotiation not available yet, use negotiate=0 to disable");
        }
        return string2;
    }

    public java_remote_bridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        this.finit$();
        String string = this.parseAttributes((String)objectArray[0]);
        this._java_environment = iEnvironment;
        Class<?> clazz = Class.forName("com.sun.star.lib.uno.protocols." + string + "." + string);
        Constructor<?> constructor = clazz.getConstructor(java_remote_bridge.class$("com.sun.star.uno.IBridge"));
        this._iProtocol = (IProtocol)constructor.newInstance(this);
        this._xConnection = (XConnection)objectArray[1];
        this._xInstanceProvider = (XInstanceProvider)objectArray[2];
        this._inputStream = new XConnectionInputStream_Adapter(this._xConnection);
        this._outputStream = new DataOutputStream(new XConnectionOutputStream_Adapter(this._xConnection));
        if (objectArray.length > 3) {
            this._name = (String)objectArray[3];
        }
        if (this._java_environment == null || this._xConnection == null || this._iProtocol == null || this._inputStream == null || this._outputStream == null) {
            throw new IllegalArgumentException(this.getClass().getName());
        }
        this._listeners = new Vector();
        this.proxyFactory = new ProxyFactory(this, this);
        this._iThreadPool = ThreadPoolManager.create();
        this._messageDispatcher = new MessageDispatcher(this);
        this._messageDispatcher.start();
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void notifyListeners() {
        EventObject eventObject = new EventObject(this);
        Enumeration enumeration = this._listeners.elements();
        while (enumeration.hasMoreElements()) {
            XEventListener xEventListener = (XEventListener)enumeration.nextElement();
            try {
                xEventListener.disposing(eventObject);
            }
            catch (com.sun.star.uno.RuntimeException runtimeException) {}
        }
    }

    public java_remote_bridge(Object[] objectArray) throws Exception {
        this(UnoRuntime.getEnvironment("java", null), UnoRuntime.getEnvironment("remote", null), objectArray);
    }

    public Object mapInterfaceTo(Object object, Type type) {
        this.checkDisposed();
        if (object == null) {
            return null;
        }
        String[] stringArray = new String[1];
        if (!this.proxyFactory.isProxy(object = this._java_environment.registerInterface(object, stringArray, type))) {
            this.addRefHolder(object, type, stringArray[0]);
        }
        return stringArray[0];
    }

    public Object mapInterfaceFrom(Object object, Type type) {
        this.checkDisposed();
        this.acquire();
        String string = (String)object;
        Object object2 = this._java_environment.getRegisteredInterface(string, type);
        if (object2 == null) {
            object2 = this._java_environment.registerInterface(this.proxyFactory.create(string, type), new String[]{string}, type);
        } else if (!this.hasRefHolder(string, type)) {
            try {
                this.sendRequest(string, type, "release", null, new Boolean[]{new Boolean(this._forceSynchronous)}, new Boolean[]{new Boolean(this._forceSynchronous)});
            }
            catch (Error error) {
                throw error;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Throwable throwable) {
                throw new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".mapInterfaceFrom - unexpected: " + throwable);
            }
        }
        return object2;
    }

    public IEnvironment getSourceEnvironment() {
        return this._java_environment;
    }

    public IEnvironment getTargetEnvironment() {
        return null;
    }

    public synchronized void acquire() {
        ++this._life_count;
    }

    public void release() {
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            boolean bl;
            try {
                --this._life_count;
                bl = this._life_count <= 0;
            }
            finally {
                Object var3_3 = null;
            }
            if (bl) {
                this.dispose(new com.sun.star.uno.RuntimeException("end of life"));
            }
            return;
        }
    }

    public void dispose() {
        this.dispose(new com.sun.star.uno.RuntimeException("user dispose"));
    }

    private void dispose(Throwable throwable) {
        Iterator iterator;
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            try {
                if (this.disposed) {
                    Object var3_3 = null;
                    return;
                }
                this.disposed = true;
            }
            catch (Throwable throwable2) {
                Object var3_5 = null;
                throw throwable2;
            }
            iterator = null;
        }
        this.notifyListeners();
        iterator = ((AbstractList)this.disposeListeners).iterator();
        while (iterator.hasNext()) {
            ((DisposeListener)iterator.next()).notifyDispose(this);
        }
        try {
            this._messageDispatcher.terminate();
            this._xConnection.close();
            if (Thread.currentThread() != this._messageDispatcher && this._messageDispatcher.isAlive()) {
                if (System.getProperty("os.name", "").toLowerCase().equals("linux") && System.getProperty("java.version", "").startsWith("1.3.") && (System.getProperty("java.vendor", "").toLowerCase().indexOf("sun") != -1 || System.getProperty("java.vendor", "").toLowerCase().indexOf("blackdown") != -1)) {
                    this._messageDispatcher.suspend();
                    this._messageDispatcher.resume();
                }
                this._messageDispatcher.join(1000);
                if (this._messageDispatcher.isAlive()) {
                    this._messageDispatcher.interrupt();
                    this._messageDispatcher.join();
                }
            }
            this._iThreadPool.dispose(throwable);
            this.freeHolders();
            ((java_environment)this._java_environment).revokeAllProxies();
            this._xConnection = null;
            this._java_environment = null;
            this._messageDispatcher = null;
        }
        catch (InterruptedException interruptedException) {
            System.err.println(this.getClass().getName() + ".dispose - InterruptedException:" + interruptedException);
        }
        catch (com.sun.star.io.IOException iOException) {
            System.err.println(this.getClass().getName() + ".dispose - IOException:" + iOException);
        }
    }

    public Object getInstance(String string) {
        Type type = new Type(java_remote_bridge.class$("com.sun.star.uno.XInterface"));
        try {
            return this.sendRequest(string, type, "queryInterface", new Object[]{type}, null, null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException("Unexpected " + throwable);
        }
    }

    public String getName() {
        return this._name;
    }

    public String getDescription() {
        return this._iProtocol.getName() + "," + this._xConnection.getDescription();
    }

    public void sendReply(boolean bl, ThreadId threadId, Object object) {
        this.checkDisposed();
        try {
            DataOutputStream dataOutputStream = this._outputStream;
            synchronized (dataOutputStream) {
                try {
                    this._iProtocol.writeReply(bl, threadId, object);
                    this._iProtocol.flush(this._outputStream);
                    this._outputStream.flush();
                }
                finally {
                    Object var5_5 = null;
                }
            }
        }
        catch (Exception exception) {
            this.dispose(exception);
            throw new DisposedException(this.getClass().getName() + ".sendReply - unexpected: " + exception);
        }
        catch (Error error) {
            this.dispose(error);
            throw error;
        }
        {
            return;
        }
    }

    public Object sendRequest(String string, Type type, String string2, Object[] objectArray) throws Throwable {
        Boolean[] booleanArray;
        Boolean[] booleanArray2;
        if (this._forceSynchronous) {
            Boolean[] booleanArray3 = new Boolean[1];
            booleanArray2 = booleanArray3;
            booleanArray3[0] = Boolean.TRUE;
        } else {
            booleanArray2 = null;
        }
        if (this._forceSynchronous) {
            Boolean[] booleanArray4 = new Boolean[1];
            booleanArray = booleanArray4;
            booleanArray4[0] = Boolean.TRUE;
        } else {
            booleanArray = null;
        }
        return this.sendRequest(string, type, string2, objectArray, booleanArray2, booleanArray);
    }

    private Object sendRequest(String string, Type type, String string2, Object[] objectArray, Boolean[] booleanArray, Boolean[] booleanArray2) throws Throwable {
        Object object;
        Object object2;
        ThreadId threadId;
        boolean bl;
        Object object3;
        block16: {
            object3 = null;
            if (booleanArray == null) {
                booleanArray = new Boolean[1];
            }
            if (booleanArray2 == null) {
                booleanArray2 = new Boolean[1];
            }
            this.checkDisposed();
            if (string2.equals("acquire")) {
                this.acquire();
            }
            bl = false;
            threadId = this._iThreadPool.getThreadId();
            object2 = null;
            try {
                DataOutputStream dataOutputStream = this._outputStream;
                synchronized (dataOutputStream) {
                    try {
                        this._iProtocol.writeRequest(string, TypeDescription.getTypeDescription(type), string2, threadId, objectArray, booleanArray, booleanArray2);
                        boolean bl2 = bl = booleanArray[0] != false && Thread.currentThread() != this._messageDispatcher;
                        if (bl) {
                            object2 = this._iThreadPool.attach(threadId);
                        }
                        try {
                            this._iProtocol.flush(this._outputStream);
                            this._outputStream.flush();
                        }
                        catch (IOException iOException) {
                            DisposedException disposedException = new DisposedException(iOException.getMessage());
                            this.dispose(disposedException);
                            throw disposedException;
                        }
                        object = null;
                    }
                    catch (Throwable throwable) {
                        Object var12_14 = null;
                        throw throwable;
                    }
                }
                if (!bl) break block16;
                object3 = this._iThreadPool.enter(object2, threadId);
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                if (bl) {
                    this._iThreadPool.detach(object2, threadId);
                }
                if (string2.equals("release")) {
                    this.release();
                }
                throw throwable;
            }
        }
        object = null;
        if (bl) {
            this._iThreadPool.detach(object2, threadId);
        }
        if (string2.equals("release")) {
            this.release();
        }
        if (string2.equals("queryInterface") && object3 instanceof Any) {
            object = (Any)object3;
            object3 = ((Any)object).getType().getTypeClass() == TypeClass.INTERFACE ? ((Any)object).getObject() : null;
        }
        object = object3;
        return object;
    }

    public void addEventListener(XEventListener xEventListener) {
        this._listeners.addElement(xEventListener);
    }

    public void removeEventListener(XEventListener xEventListener) {
        this._listeners.removeElement(xEventListener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        java_remote_bridge java_remote_bridge2 = this;
        synchronized (java_remote_bridge2) {
            block3: {
                try {
                    if (this.disposed) break block3;
                    this.disposeListeners.add(disposeListener);
                    Object var3_3 = null;
                    return;
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    throw throwable;
                }
            }
            Object var3_4 = null;
        }
        disposeListener.notifyDispose(this);
    }

    private synchronized void checkDisposed() {
        if (this.disposed) {
            throw new DisposedException("java_remote_bridge " + this + " is disposed");
        }
    }

    private static final class RefHolder {
        private final Type type;
        private final Object object;
        private int count;

        private /* synthetic */ void finit$() {
            this.count = 1;
        }

        public RefHolder(Type type, Object object) {
            this.finit$();
            this.type = type;
            this.object = object;
        }

        public Type getType() {
            return this.type;
        }

        public void acquire() {
            ++this.count;
        }

        public boolean release() {
            return --this.count == 0;
        }
    }

    public class MessageDispatcher
    extends Thread
    implements IInvokable {
        private /* synthetic */ java_remote_bridge this$0;
        private ThreadId _threadId;
        private boolean terminate;

        private /* synthetic */ void finit$() {
            this.terminate = false;
        }

        MessageDispatcher(java_remote_bridge java_remote_bridge2) {
            this.this$0 = java_remote_bridge2;
            super("MessageDispatcher");
            this.finit$();
        }

        public void run() {
            this._threadId = this.this$0._iThreadPool.getThreadId();
            if (__MessageDispatcher_run_hook != null) {
                try {
                    __MessageDispatcher_run_hook.invoke(this, null);
                }
                catch (Exception exception) {
                    System.err.println(this.getClass().getName() + " - unexpected: method >invoke< threw an exception - " + exception);
                    exception.printStackTrace();
                }
            } else {
                this.invoke(null);
            }
        }

        public Object invoke(Object[] objectArray) {
            IMessage iMessage;
            try {
                while (true) {
                    String[] stringArray;
                    Object object;
                    MessageDispatcher messageDispatcher = this;
                    synchronized (messageDispatcher) {
                        block21: {
                            try {
                                if (!this.terminate) break block21;
                                iMessage = null;
                                break;
                            }
                            catch (Throwable throwable) {
                                iMessage = null;
                                throw throwable;
                            }
                        }
                        iMessage = null;
                    }
                    iMessage = this.this$0._iProtocol.readMessage(this.this$0._inputStream);
                    if (iMessage.getThreadId().equals(this._threadId)) continue;
                    String string = iMessage.getOperation();
                    String string2 = iMessage.getOid();
                    if (string != null && string.equals("release")) {
                        object = new Type(iMessage.getInterface());
                        this.this$0._java_environment.revokeInterface(string2, (Type)object);
                        this.this$0.remRefHolder((Type)object, string2);
                        if (iMessage.mustReply()) {
                            this.this$0.sendReply(false, iMessage.getThreadId(), null);
                        }
                    } else if (string != null && string.equals("acquire")) {
                        object = new Type(iMessage.getInterface());
                        stringArray = new String[]{string2};
                        this.this$0._java_environment.registerInterface(null, stringArray, (Type)object);
                        this.this$0.addRefHolder(null, (Type)object, string2);
                    } else {
                        object = null;
                        if (string != null) {
                            stringArray = new Type(iMessage.getInterface());
                            object = this.this$0._java_environment.getRegisteredInterface(string2, (Type)stringArray);
                            com.sun.star.uno.RuntimeException runtimeException = null;
                            if (object == null) {
                                if (this.this$0._xInstanceProvider == null) {
                                    runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch - no instance provider set and unknown object:" + string2);
                                } else {
                                    try {
                                        object = this.this$0._xInstanceProvider.getInstance(string2);
                                        if (object == null && !string.equals("queryInterface")) {
                                            runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch: instance provider returned null and operation >" + string + "< not supported on null");
                                        }
                                    }
                                    catch (NoSuchElementException noSuchElementException) {
                                        runtimeException = new com.sun.star.uno.RuntimeException(this.getClass().getName() + ".dispatch - wrapped exception:" + noSuchElementException);
                                    }
                                    catch (com.sun.star.uno.RuntimeException runtimeException2) {
                                        runtimeException = runtimeException2;
                                    }
                                }
                            }
                            if (runtimeException != null) {
                                this.this$0.sendReply(true, iMessage.getThreadId(), runtimeException);
                                iMessage = null;
                            }
                        }
                        if (iMessage != null) {
                            stringArray = new Job(object, this.this$0, iMessage);
                            this.this$0._iThreadPool.putJob((Job)stringArray);
                            stringArray = null;
                        }
                    }
                    iMessage = null;
                }
            }
            catch (Throwable throwable) {
                this.this$0.dispose(new DisposedException(throwable.toString()));
            }
            iMessage = null;
            return iMessage;
        }

        public synchronized void terminate() {
            this.terminate = true;
        }
    }
}

