/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.uno;

import com.sun.star.lib.util.WeakMap;
import com.sun.star.uno.Any;
import com.sun.star.uno.IBridge;
import com.sun.star.uno.IEnvironment;
import com.sun.star.uno.IMapping;
import com.sun.star.uno.IQueryInterface;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.Type;
import com.sun.star.uno.TypeClass;
import com.sun.star.uno.XCurrentContext;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;

public class UnoRuntime {
    public static final boolean DEBUG = false;
    private static final String uniqueKeyHostPrefix = Integer.toString(new Object().hashCode(), 16) + ":";
    private static final Object uniqueKeyLock = new Object();
    private static long uniqueKeyTime = System.currentTimeMillis();
    private static long uniqueKeyCount = Long.MIN_VALUE;
    private static final String oidSuffix = ";java[];" + UnoRuntime.getUniqueKey();
    private static final ThreadLocal currentContext = new ThreadLocal();
    private static final WeakMap environments = new WeakMap();
    private static final WeakMap bridges = new WeakMap();

    public static String getUniqueKey() {
        Object object = uniqueKeyLock;
        synchronized (object) {
            try {
                if (uniqueKeyCount == Long.MAX_VALUE) {
                    long l = System.currentTimeMillis();
                    while (l == uniqueKeyTime) {
                        try {
                            Thread.sleep(100);
                        }
                        catch (InterruptedException interruptedException) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    uniqueKeyTime = l;
                    uniqueKeyCount = Long.MIN_VALUE;
                }
                String string = uniqueKeyHostPrefix + Long.toString(uniqueKeyTime, 16) + ":" + Long.toString(uniqueKeyCount++, 16);
                Object var2_5 = null;
                return string;
            }
            catch (Throwable throwable) {
                Object var2_6 = null;
                throw throwable;
            }
        }
    }

    public static String generateOid(Object object) {
        String string = null;
        if (object instanceof IQueryInterface) {
            string = ((IQueryInterface)object).getOid();
        }
        if (string == null) {
            return object.hashCode() + oidSuffix;
        }
        return string;
    }

    public static Object queryInterface(Type type, Object object) {
        Object object2;
        if (object instanceof Any && ((Any)(object2 = (Any)object)).getType().getTypeClass() == TypeClass.INTERFACE) {
            object = ((Any)object2).getObject();
        }
        if (object instanceof IQueryInterface && (object = ((IQueryInterface)object).queryInterface(type)) instanceof Any) {
            object2 = (Any)object;
            Object object3 = object = ((Any)object2).getType().getTypeClass() == TypeClass.INTERFACE ? ((Any)object2).getObject() : null;
        }
        if ((object2 = type.getZClass()) == null || !((Class)object2).isInstance(object)) {
            object = null;
        }
        return object;
    }

    public static Object queryInterface(Class clazz, Object object) {
        return UnoRuntime.queryInterface(new Type(clazz), object);
    }

    public static boolean areSame(Object object, Object object2) {
        return object == object2 || object instanceof IQueryInterface && ((IQueryInterface)object).isSame(object2) || object2 instanceof IQueryInterface && ((IQueryInterface)object2).isSame(object);
    }

    public static XCurrentContext getCurrentContext() {
        return (XCurrentContext)currentContext.get();
    }

    public static void setCurrentContext(XCurrentContext xCurrentContext) {
        currentContext.set(xCurrentContext);
    }

    public static IEnvironment getEnvironment(String string, Object object) throws Exception {
        WeakMap weakMap = environments;
        synchronized (weakMap) {
            try {
                Constructor constructor;
                Object object2;
                IEnvironment iEnvironment = (IEnvironment)WeakMap.getValue(environments.get(string + object));
                if (iEnvironment == null) {
                    object2 = Class.forName("com.sun.star.lib.uno.environments." + string + "." + string + "_environment");
                    constructor = ((Class)object2).getConstructor(UnoRuntime.class$("java.lang.Object"));
                    iEnvironment = (IEnvironment)constructor.newInstance(object);
                    environments.put(string + object, iEnvironment);
                }
                object2 = iEnvironment;
                constructor = null;
                return object2;
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static IBridge getBridge(IEnvironment iEnvironment, IEnvironment iEnvironment2, Object[] objectArray) throws Exception {
        WeakMap weakMap = bridges;
        synchronized (weakMap) {
            try {
                String string;
                Class<?> clazz;
                String string2 = iEnvironment.getName() + "_" + iEnvironment2.getName();
                String string3 = iEnvironment.getName() + iEnvironment.getContext() + "_" + iEnvironment2.getName() + iEnvironment2.getContext();
                IBridge iBridge = (IBridge)WeakMap.getValue(bridges.get(string3));
                if (iBridge == null) {
                    clazz = null;
                    string = string2 + "_bridge";
                    try {
                        clazz = Class.forName(string);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        string = "com.sun.star.lib.uno.bridges." + string2 + "." + string;
                        clazz = Class.forName(string);
                    }
                    Class[] classArray = new Class[]{UnoRuntime.class$("com.sun.star.uno.IEnvironment"), UnoRuntime.class$("com.sun.star.uno.IEnvironment"), objectArray.getClass()};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object[] objectArray2 = new Object[]{iEnvironment, iEnvironment2, objectArray};
                    iBridge = (IBridge)constructor.newInstance(objectArray2);
                    bridges.put(string3, iBridge);
                }
                clazz = iBridge;
                string = null;
                return clazz;
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                throw throwable;
            }
        }
    }

    public static IBridge getBridgeByName(String string, Object object, String string2, Object object2, Object[] objectArray) throws Exception {
        return UnoRuntime.getBridge(UnoRuntime.getEnvironment(string, object), UnoRuntime.getEnvironment(string2, object2), objectArray);
    }

    public static IBridge[] getBridges() {
        IBridge[] iBridgeArray;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        WeakMap weakMap = bridges;
        synchronized (weakMap) {
            try {
                iBridgeArray = bridges.values().iterator();
                while (iBridgeArray.hasNext()) {
                    Object object = WeakMap.getValue(iBridgeArray.next());
                    if (object == null) continue;
                    arrayList.add(object);
                }
                iBridgeArray = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
        iBridgeArray = arrayList.toArray(new IBridge[arrayList.size()]);
        return iBridgeArray;
    }

    public static IMapping getMapping(IEnvironment iEnvironment, IEnvironment iEnvironment2) throws Exception {
        IBridge iBridge;
        try {
            iBridge = UnoRuntime.getBridge(iEnvironment, iEnvironment2, null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            iBridge = new BridgeTurner(UnoRuntime.getBridge(iEnvironment2, iEnvironment, null));
        }
        return new MappingWrapper(iBridge);
    }

    public static IMapping getMappingByName(String string, String string2) throws Exception {
        return UnoRuntime.getMapping(UnoRuntime.getEnvironment(string, null), UnoRuntime.getEnvironment(string2, null));
    }

    public static boolean reset() {
        WeakMap weakMap = bridges;
        synchronized (weakMap) {
            Iterator iterator;
            try {
                iterator = bridges.values().iterator();
                while (iterator.hasNext()) {
                    IBridge iBridge = (IBridge)WeakMap.getValue(iterator.next());
                    if (iBridge == null) continue;
                    try {
                        iBridge.dispose();
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread();
                        Thread.interrupted();
                        throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + interruptedException);
                    }
                    catch (IOException iOException) {
                        throw new RuntimeException("Unexpected exception in UnoRuntime.reset: " + iOException);
                    }
                }
                bridges.clear();
            }
            finally {
                iterator = null;
            }
            environments.clear();
            boolean bl = bridges.isEmpty() && environments.isEmpty();
            return bl;
        }
    }

    private static final class MappingWrapper
    implements IMapping {
        private final IBridge bridge;

        public MappingWrapper(IBridge iBridge) {
            this.bridge = iBridge;
        }

        public Object mapInterface(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }
    }

    private static final class BridgeTurner
    implements IBridge {
        private final IBridge bridge;

        public BridgeTurner(IBridge iBridge) {
            this.bridge = iBridge;
        }

        public Object mapInterfaceTo(Object object, Type type) {
            return this.bridge.mapInterfaceFrom(object, type);
        }

        public Object mapInterfaceFrom(Object object, Type type) {
            return this.bridge.mapInterfaceTo(object, type);
        }

        public IEnvironment getSourceEnvironment() {
            return this.bridge.getTargetEnvironment();
        }

        public IEnvironment getTargetEnvironment() {
            return this.bridge.getSourceEnvironment();
        }

        public void acquire() {
            this.bridge.acquire();
        }

        public void release() {
            this.bridge.release();
        }

        public void dispose() throws InterruptedException, IOException {
            this.bridge.dispose();
        }
    }
}

