/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.tools.uno;

import com.sun.star.uno.Type;

public class DumpType {
    private static final String[] __typeClassToTypeName = new String[]{"void", "char", "boolean", "byte", "short", "unsigned short", "long", "unsigned long", "hyper", "unsigned hyper", "float", "double", "string", "type", "any", "enum", "typedef", "struct", "union", "exception", "sequence", "array", "interface", "service", "module", "interface_method", "interface_attribute", "unknown"};

    public static void dumpType(Type type) throws Exception {
        System.err.println("uno type name:" + type.getTypeName());
        System.err.println("description:" + type.getTypeDescription());
        System.err.println("java class:" + type.getZClass());
        System.err.println("type class:" + __typeClassToTypeName[type.getTypeClass().getValue()]);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length == 0) {
            System.err.println("usage: [uno <type name>]|[java <class name>]*");
        } else {
            for (int i = 0; i < stringArray.length; i += 2) {
                Type type = null;
                type = stringArray[i].equals("uno") ? new Type(stringArray[i + 1]) : new Type(Class.forName(stringArray[i + 1]));
                DumpType.dumpType(type);
            }
        }
    }
}

