/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.GZip;
import org.apache.tools.ant.taskdefs.Tar;
import org.apache.tools.ant.taskdefs.Zip;

public class Zipper {
    public static void zipFolder(File srcFolder, File destZipFile, String includesdir) {
        Zip zipper = new Zip();
        zipper.setDestFile(destZipFile);
        zipper.setBasedir(srcFolder);
        zipper.setIncludes(includesdir.replace(" ", "*"));
        zipper.setUpdate(true);
        zipper.setCompress(true);
        zipper.setCaseSensitive(false);
        zipper.setFilesonly(false);
        zipper.setTaskName("zip");
        zipper.setTaskType("zip");
        zipper.setProject(new Project());
        zipper.setOwningTarget(new Target());
        zipper.execute();
        System.out.println(destZipFile);
    }

    public static void tarFolder(File srcFolder, File destTarFile, String includesdir) {
        Tar tarer = new Tar();
        tarer.setDestFile(destTarFile);
        tarer.setBasedir(srcFolder);
        tarer.setIncludes(includesdir);
        tarer.setCaseSensitive(false);
        tarer.setTaskName("tar");
        tarer.setTaskType("tar");
        tarer.setProject(new Project());
        tarer.setOwningTarget(new Target());
        tarer.execute();
    }

    public static void gzipFile(File srcFile, File destFile) {
        GZip GZiper = new GZip();
        GZiper.setDestfile(destFile);
        GZiper.setSrc(srcFile);
        GZiper.setTaskName("gzip");
        GZiper.setTaskType("gzip");
        GZiper.setProject(new Project());
        GZiper.setOwningTarget(new Target());
        GZiper.execute();
    }

    public static void unpackFile(File zipFilepath, File destinationDir) {
        Expand Unzipper = new Expand();
        Unzipper.setDest(destinationDir);
        Unzipper.setSrc(zipFilepath);
        Unzipper.setTaskType("unzip");
        Unzipper.setTaskName("unzip");
        Unzipper.setProject(new Project());
        Unzipper.setOwningTarget(new Target());
        Unzipper.execute();
    }

    public static String getParentDir(File zipFilepath) {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(zipFilepath);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            ZipEntry entry = entries.nextElement();
            File tempfile = new File(entry.getName());
            while (tempfile.getParent() != null) {
                tempfile = tempfile.getParentFile();
            }
            String string = tempfile.getName();
            return string;
        }
        catch (IOException ioe) {
            System.err.println("Unhandled exception:");
            ioe.printStackTrace();
            return "";
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
                zipFile = null;
            }
        }
    }
}

