/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pipo2;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.pipo2.ElementHandler;
import org.adempiere.pipo2.IHandlerRegistry;
import org.adempiere.pipo2.OSGiHandlerRegistry;
import org.adempiere.pipo2.PIPOContext;
import org.adempiere.pipo2.PackoutDocument;
import org.adempiere.pipo2.PackoutItem;
import org.adempiere.pipo2.Zipper;
import org.compiere.model.MClient;
import org.compiere.model.MSysConfig;
import org.compiere.util.CLogger;
import org.compiere.util.Trx;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PackOut {
    public static final String PackOutVersion = "100";
    private static final CLogger log = CLogger.getCLogger(PackOut.class);
    private String packageDirectory;
    private int blobCount = 0;
    private IHandlerRegistry handlerRegistry = new OSGiHandlerRegistry();
    private PackoutItem packoutItem;
    private String trxName;
    private PackoutDocument packoutDocument;
    private int processedCount;
    private String exportFile;
    private String packoutDirectory;
    private PIPOContext pipoContext = new PIPOContext();
    private Timestamp fromDate;
    private boolean isExportDictionaryEntity = false;
    public static final int MAX_OFFICIAL_ID = 999999;
    private List<String> processedRecords = new ArrayList<String>();

    public static void addTextElement(TransformerHandler handler, String qName, String text, AttributesImpl atts) throws SAXException {
        handler.startElement("", "", qName, atts);
        PackOut.append(handler, text);
        handler.endElement("", "", qName);
    }

    private static void append(TransformerHandler handler, String str) throws SAXException {
        char[] contents = str != null ? str.toCharArray() : new char[]{};
        handler.characters(contents, 0, contents.length);
    }

    public void export(String packoutDirectory, String destinationPath, PackoutDocument packoutDocument, List<PackoutItem> packoutItems, String trxName) throws Exception {
        this.packoutDirectory = packoutDirectory;
        this.packoutDocument = packoutDocument;
        this.trxName = trxName;
        this.initContext();
        OutputStream docStream = null;
        OutputStream packoutStream = null;
        this.processedCount = 0;
        try {
            try {
                boolean success;
                this.packageDirectory = String.valueOf(packoutDirectory) + packoutDocument.getPackageName();
                File docDirectoryFile = new File(String.valueOf(this.packageDirectory) + File.separator + "doc" + File.separator);
                if (!docDirectoryFile.exists() && !(success = docDirectoryFile.mkdirs())) {
                    throw new AdempiereException("Failed to create directory for pack out. " + this.packageDirectory + File.separator + "doc" + File.separator);
                }
                String docFileName = String.valueOf(this.packageDirectory) + File.separator + "doc" + File.separator + packoutDocument.getPackageName() + "Doc.xml";
                docStream = new FileOutputStream(docFileName, false);
                TransformerHandler docHandler = this.createDocHandler(docStream);
                String packoutFileName = String.valueOf(this.packageDirectory) + File.separator + "dict" + File.separator + "PackOut.xml";
                packoutStream = new FileOutputStream(packoutFileName, false);
                TransformerHandler packoutHandler = this.createPackoutHandler(packoutStream);
                Iterator<PackoutItem> iterator = packoutItems.iterator();
                while (iterator.hasNext()) {
                    PackoutItem packoutItem;
                    this.packoutItem = packoutItem = iterator.next();
                    String type = packoutItem.getType();
                    ElementHandler handler = this.handlerRegistry.getHandler(type);
                    if (handler == null) {
                        throw new IllegalArgumentException("Packout handler not found for type " + type);
                    }
                    handler.packOut(this, packoutHandler, docHandler, packoutItem.getRecordId());
                    ++this.processedCount;
                }
                packoutHandler.endElement("", "", "idempiere");
                packoutHandler.endDocument();
                docHandler.endElement("", "", "idempiereDocument");
                docHandler.endDocument();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, e.getLocalizedMessage(), (Throwable)e);
                throw e;
            }
        }
        finally {
            if (docStream != null) {
                try {
                    docStream.close();
                }
                catch (Exception exception) {}
            }
            if (packoutStream != null) {
                try {
                    packoutStream.close();
                }
                catch (Exception exception) {}
            }
        }
        File srcFolder = new File(packoutDirectory);
        File destZipFile = null;
        destZipFile = destinationPath != null && destinationPath.trim().length() > 0 ? new File(destinationPath) : new File(String.valueOf(this.packageDirectory) + ".zip");
        destZipFile.delete();
        String includesdir = String.valueOf(packoutDocument.getPackageName()) + File.separator + "**";
        Zipper.zipFolder(srcFolder, destZipFile, includesdir);
        this.exportFile = destZipFile.getAbsolutePath();
    }

    private TransformerHandler createPackoutHandler(OutputStream packoutStream) throws UnsupportedEncodingException, TransformerConfigurationException, SAXException {
        StreamResult packoutStreamResult = new StreamResult(new OutputStreamWriter(packoutStream, "UTF-8"));
        SAXTransformerFactory packoutFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            packoutFactory.setAttribute("indent-number", new Integer(4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransformerHandler packoutHandler = packoutFactory.newTransformerHandler();
        Transformer packoutTransformer = packoutHandler.getTransformer();
        packoutTransformer.setOutputProperty("encoding", "UTF-8");
        packoutTransformer.setOutputProperty("indent", "yes");
        try {
            packoutTransformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        catch (Exception exception) {
            // empty catch block
        }
        packoutHandler.setResult(packoutStreamResult);
        packoutHandler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        atts.addAttribute("", "", "Name", "CDATA", this.packoutDocument.getPackageName());
        atts.addAttribute("", "", "Version", "CDATA", this.packoutDocument.getPackageVersion());
        atts.addAttribute("", "", "idempiereVersion", "CDATA", this.emptyIfNull(this.packoutDocument.getAdempiereVersion()));
        atts.addAttribute("", "", "DataBaseVersion", "CDATA", this.emptyIfNull(this.packoutDocument.getDatabaseVersion()));
        atts.addAttribute("", "", "Description", "CDATA", this.emptyIfNull(this.packoutDocument.getDescription()));
        atts.addAttribute("", "", "Author", "CDATA", this.emptyIfNull(this.packoutDocument.getAuthor()));
        atts.addAttribute("", "", "AuthorEmail", "CDATA", this.emptyIfNull(this.packoutDocument.getAuthorEmail()));
        atts.addAttribute("", "", "CreatedDate", "CDATA", this.packoutDocument.getCreated().toString());
        atts.addAttribute("", "", "UpdatedDate", "CDATA", this.packoutDocument.getUpdated().toString());
        atts.addAttribute("", "", "PackOutVersion", "CDATA", PackOutVersion);
        atts.addAttribute("", "", "UpdateDictionary", "CDATA", this.isExportDictionaryEntity ? "true" : "false");
        MClient client = MClient.get((Properties)this.pipoContext.ctx);
        StringBuffer sb = new StringBuffer().append(client.get_ID()).append("-").append(client.getValue()).append("-").append(client.getName());
        atts.addAttribute("", "", "Client", "CDATA", sb.toString());
        atts.addAttribute("", "", "AD_Client_UU", "CDATA", client.getAD_Client_UU());
        packoutHandler.startElement("", "", "idempiere", atts);
        return packoutHandler;
    }

    private String emptyIfNull(String input) {
        return input != null ? input : "";
    }

    private TransformerHandler createDocHandler(OutputStream docStream) throws UnsupportedEncodingException, TransformerConfigurationException, SAXException {
        boolean success;
        StreamResult docStreamResult = new StreamResult(new OutputStreamWriter(docStream, "UTF-8"));
        SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            transformerFactory.setAttribute("indent-number", new Integer(4));
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransformerHandler docHandler = transformerFactory.newTransformerHandler();
        Transformer transformer = docHandler.getTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("indent", "yes");
        try {
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "4");
        }
        catch (Exception exception) {
            // empty catch block
        }
        docHandler.setResult(docStreamResult);
        docHandler.startDocument();
        docHandler.processingInstruction("xml-stylesheet", "type=\"text/css\" href=\"idempiereDocument.css\"");
        AttributesImpl atts = new AttributesImpl();
        docHandler.startElement("", "", "idempiereDocument", atts);
        PackOut.addTextElement(docHandler, "header", String.valueOf(this.packoutDocument.getPackageName()) + " Package Description", atts);
        PackOut.addTextElement(docHandler, "H1", "Package Name:", atts);
        PackOut.addTextElement(docHandler, "packagename", this.packoutDocument.getPackageName(), atts);
        PackOut.addTextElement(docHandler, "H1", "Author:", atts);
        PackOut.addTextElement(docHandler, "Name:", this.packoutDocument.getAuthor(), atts);
        PackOut.addTextElement(docHandler, "H1", "Email Address:", atts);
        PackOut.addTextElement(docHandler, "Email", this.packoutDocument.getAuthorEmail(), atts);
        PackOut.addTextElement(docHandler, "H1", "Created:", atts);
        PackOut.addTextElement(docHandler, "Date", this.packoutDocument.getCreated().toString(), atts);
        PackOut.addTextElement(docHandler, "H1", "Updated:", atts);
        PackOut.addTextElement(docHandler, "Date", this.packoutDocument.getUpdated().toString(), atts);
        PackOut.addTextElement(docHandler, "H1", "Description:", atts);
        PackOut.addTextElement(docHandler, "description", this.packoutDocument.getDescription(), atts);
        PackOut.addTextElement(docHandler, "H1", "Instructions:", atts);
        PackOut.addTextElement(docHandler, "instructions", this.packoutDocument.getInstructions(), atts);
        PackOut.addTextElement(docHandler, "H1", "Files in Package:", atts);
        PackOut.addTextElement(docHandler, "file", "File: PackOut.xml", atts);
        PackOut.addTextElement(docHandler, "filedirectory", "Directory: \\dict\\", atts);
        PackOut.addTextElement(docHandler, "filenotes", "Notes: Contains all application/object settings for package", atts);
        MClient client = MClient.get((Properties)this.pipoContext.ctx);
        StringBuffer sb = new StringBuffer().append(client.get_ID()).append("-").append(client.getValue()).append("-").append(client.getName());
        PackOut.addTextElement(docHandler, "H1", "Client:", atts);
        PackOut.addTextElement(docHandler, "Client", sb.toString(), atts);
        File packageDictDirFile = new File(String.valueOf(this.packageDirectory) + File.separator + "dict" + File.separator);
        if (!packageDictDirFile.exists() && !(success = packageDictDirFile.mkdirs())) {
            throw new AdempiereException("Failed to create directory. " + this.packageDirectory + File.separator + "dict" + File.separator);
        }
        return docHandler;
    }

    private void initContext() {
        if (this.trxName != null) {
            this.pipoContext.trx = Trx.get((String)this.trxName, (boolean)true);
        }
        this.pipoContext.ctx.setProperty("isHandleTranslations", MSysConfig.getValue((String)"2PACK_HANDLE_TRANSLATIONS"));
        this.pipoContext.packOut = this;
    }

    public void copyFile(String sourceName, String destName) {
        FileInputStream source = null;
        OutputStream copy = null;
        boolean force = true;
        try {
            source = new FileInputStream(sourceName);
        }
        catch (FileNotFoundException e) {
            System.out.println("Can't find file \"" + sourceName + "\".");
            return;
        }
        try {
            File file = new File(destName);
            if (file.exists() && !force) {
                System.out.println("Output file exists. Use the -f option to replace it.");
                return;
            }
            try {
                copy = new FileOutputStream(destName, false);
            }
            catch (IOException e) {
                System.out.println("Can't open output file \"" + destName + "\".");
                if (source != null) {
                    try {
                        ((InputStream)source).close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (copy != null) {
                    try {
                        copy.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            int byteCount = 0;
            try {
                int data;
                while ((data = ((InputStream)source).read()) >= 0) {
                    copy.write(data);
                    ++byteCount;
                }
                ((InputStream)source).close();
                copy.close();
                System.out.println("Successfully copied " + byteCount + " bytes.");
            }
            catch (Exception e) {
                System.out.println("Error occurred while copying.  " + byteCount + " bytes copied.");
                System.out.println(e.toString());
            }
        }
        finally {
            if (source != null) {
                try {
                    ((InputStream)source).close();
                }
                catch (IOException iOException) {}
            }
            if (copy != null) {
                try {
                    copy.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public PIPOContext getCtx() {
        return this.pipoContext;
    }

    public String writeBlob(byte[] data) throws IOException {
        ++this.blobCount;
        String fileName = String.valueOf(this.blobCount) + ".dat";
        File path = new File(String.valueOf(this.packageDirectory) + File.separator + "blobs" + File.separator);
        path.mkdirs();
        File file = new File(path, fileName);
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(file);
            os.write(data);
            os.flush();
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        return fileName;
    }

    public PackoutItem getCurrentPackoutItem() {
        return this.packoutItem;
    }

    public PackoutDocument getPackoutDocument() {
        return this.packoutDocument;
    }

    public String getPackoutDirectory() {
        return this.packoutDirectory;
    }

    public ElementHandler getHandler(String name) {
        return this.handlerRegistry.getHandler(name);
    }

    public int getExportCount() {
        return this.processedCount;
    }

    public String getExportFile() {
        return this.exportFile;
    }

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public Timestamp getFromDate() {
        return this.fromDate;
    }

    public void setCtx(Properties ctx) {
        this.pipoContext.ctx = ctx;
    }

    public boolean isExported(String key) {
        if (this.processedRecords.contains(key)) {
            return true;
        }
        this.processedRecords.add(key);
        return false;
    }

    public boolean isExportDictionaryEntity() {
        return this.isExportDictionaryEntity;
    }

    public void setExportDictionaryEntity(boolean isExportDictionaryEntity) {
        this.isExportDictionaryEntity = isExportDictionaryEntity;
    }
}

