/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ecs.storage;

import java.io.Serializable;
import java.util.Enumeration;
import org.apache.ecs.storage.Array;
import org.apache.ecs.storage.NoSuchObjectException;

public class Hash
implements Serializable {
    private static final long serialVersionUID = 7635193444611108511L;
    private Array keys = new Array();
    private Array elements = new Array();

    public void setSize(int newSize) {
        this.keys.setSize(newSize);
        this.elements.setSize(newSize);
    }

    public void setGrow(int growBy) {
        this.keys.setGrow(growBy);
        this.elements.setGrow(growBy);
    }

    public synchronized void put(String key, Object element) {
        try {
            if (this.containsKey(key)) {
                this.elements.add(this.keys.location(key), element);
            } else {
                this.keys.add(key);
                this.elements.add(element);
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public synchronized void remove(String key) {
        try {
            if (this.containsKey(key)) {
                this.elements.remove(this.keys.location(key));
                this.elements.remove(this.elements.location(key));
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
    }

    public int size() {
        return this.keys.getCurrentSize();
    }

    public boolean contains(Object element) {
        try {
            this.elements.location(element);
            return true;
        }
        catch (NoSuchObjectException noSuchObject) {
            return false;
        }
    }

    public Enumeration<Object> keys() {
        return this.keys;
    }

    public boolean containsKey(String key) {
        try {
            this.keys.location(key);
        }
        catch (NoSuchObjectException noSuchObject) {
            return false;
        }
        return true;
    }

    public Enumeration<Object> elements() {
        return this.elements;
    }

    public Object get(String key) {
        try {
            if (this.containsKey(key)) {
                return this.elements.get(this.keys.location(key));
            }
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        return null;
    }
}

