/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.store;

import java.io.IOException;
import org.apache.activemq.broker.ConnectionContext;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.Message;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageId;
import org.apache.activemq.command.SubscriptionInfo;
import org.apache.activemq.store.MessageRecoveryListener;
import org.apache.activemq.store.MessageStore;
import org.apache.activemq.store.TopicMessageStore;
import org.apache.activemq.usage.MemoryUsage;

public class ProxyTopicMessageStore
implements TopicMessageStore {
    final TopicMessageStore delegate;

    public ProxyTopicMessageStore(TopicMessageStore delegate) {
        this.delegate = delegate;
    }

    public MessageStore getDelegate() {
        return this.delegate;
    }

    public void addMessage(ConnectionContext context, Message message) throws IOException {
        this.delegate.addMessage(context, message);
    }

    public Message getMessage(MessageId identity) throws IOException {
        return this.delegate.getMessage(identity);
    }

    public void recover(MessageRecoveryListener listener) throws Exception {
        this.delegate.recover(listener);
    }

    public void removeAllMessages(ConnectionContext context) throws IOException {
        this.delegate.removeAllMessages(context);
    }

    public void removeMessage(ConnectionContext context, MessageAck ack) throws IOException {
        this.delegate.removeMessage(context, ack);
    }

    public void start() throws Exception {
        this.delegate.start();
    }

    public void stop() throws Exception {
        this.delegate.stop();
    }

    public SubscriptionInfo lookupSubscription(String clientId, String subscriptionName) throws IOException {
        return this.delegate.lookupSubscription(clientId, subscriptionName);
    }

    public void acknowledge(ConnectionContext context, String clientId, String subscriptionName, MessageId messageId) throws IOException {
        this.delegate.acknowledge(context, clientId, subscriptionName, messageId);
    }

    public void addSubsciption(SubscriptionInfo subscriptionInfo, boolean retroactive) throws IOException {
        this.delegate.addSubsciption(subscriptionInfo, retroactive);
    }

    public void deleteSubscription(String clientId, String subscriptionName) throws IOException {
        this.delegate.deleteSubscription(clientId, subscriptionName);
    }

    public void recoverSubscription(String clientId, String subscriptionName, MessageRecoveryListener listener) throws Exception {
        this.delegate.recoverSubscription(clientId, subscriptionName, listener);
    }

    public void recoverNextMessages(String clientId, String subscriptionName, int maxReturned, MessageRecoveryListener listener) throws Exception {
        this.delegate.recoverNextMessages(clientId, subscriptionName, maxReturned, listener);
    }

    public void resetBatching(String clientId, String subscriptionName) {
        this.delegate.resetBatching(clientId, subscriptionName);
    }

    public ActiveMQDestination getDestination() {
        return this.delegate.getDestination();
    }

    public SubscriptionInfo[] getAllSubscriptions() throws IOException {
        return this.delegate.getAllSubscriptions();
    }

    public void setMemoryUsage(MemoryUsage memoryUsage) {
        this.delegate.setMemoryUsage(memoryUsage);
    }

    public int getMessageCount(String clientId, String subscriberName) throws IOException {
        return this.delegate.getMessageCount(clientId, subscriberName);
    }

    public int getMessageCount() throws IOException {
        return this.delegate.getMessageCount();
    }

    public void recoverNextMessages(int maxReturned, MessageRecoveryListener listener) throws Exception {
        this.delegate.recoverNextMessages(maxReturned, listener);
    }

    public void dispose(ConnectionContext context) {
        this.delegate.dispose(context);
    }

    public void resetBatching() {
        this.delegate.resetBatching();
    }

    public void setBatch(MessageId messageId) throws Exception {
        this.delegate.setBatch(messageId);
    }
}

