/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.broker.region;

import java.io.IOException;
import javax.jms.JMSException;
import org.apache.activemq.broker.region.MessageReference;
import org.apache.activemq.broker.region.Queue;
import org.apache.activemq.broker.region.QueueMessageReference;
import org.apache.activemq.broker.region.Subscription;
import org.apache.activemq.broker.region.group.MessageGroupMap;
import org.apache.activemq.broker.region.policy.SimpleDispatchSelector;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQMessage;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.Message;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueueDispatchSelector
extends SimpleDispatchSelector {
    private static final Log LOG = LogFactory.getLog(QueueDispatchSelector.class);
    private Subscription exclusiveConsumer;

    public QueueDispatchSelector(ActiveMQDestination destination) {
        super(destination);
    }

    public Subscription getExclusiveConsumer() {
        return this.exclusiveConsumer;
    }

    public void setExclusiveConsumer(Subscription exclusiveConsumer) {
        this.exclusiveConsumer = exclusiveConsumer;
    }

    public boolean isExclusiveConsumer(Subscription s) {
        return s == this.exclusiveConsumer;
    }

    public boolean canSelect(Subscription subscription, MessageReference m) throws Exception {
        boolean result = super.canDispatch(subscription, m);
        if (result && !subscription.isBrowser()) {
            boolean bl = result = this.exclusiveConsumer == null || this.exclusiveConsumer == subscription;
            if (result) {
                QueueMessageReference node = (QueueMessageReference)m;
                String groupId = node.getGroupID();
                int sequence = node.getGroupSequence();
                if (groupId != null) {
                    MessageGroupMap messageGroupOwners = ((Queue)node.getRegionDestination()).getMessageGroupOwners();
                    if (sequence == 1) {
                        this.assignGroup(subscription, messageGroupOwners, node, groupId);
                    } else {
                        ConsumerId groupOwner = messageGroupOwners.get(groupId);
                        if (groupOwner == null) {
                            this.assignGroup(subscription, messageGroupOwners, node, groupId);
                        } else if (groupOwner.equals(subscription.getConsumerInfo().getConsumerId())) {
                            if (sequence < 0) {
                                messageGroupOwners.removeGroup(groupId);
                            }
                        } else {
                            result = false;
                        }
                    }
                }
            }
        }
        return result;
    }

    protected void assignGroup(Subscription subs, MessageGroupMap messageGroupOwners, MessageReference n, String groupId) throws IOException {
        messageGroupOwners.put(groupId, subs.getConsumerInfo().getConsumerId());
        Message message = n.getMessage();
        if (message instanceof ActiveMQMessage) {
            ActiveMQMessage activeMessage = (ActiveMQMessage)message;
            try {
                activeMessage.setBooleanProperty("JMSXGroupFirstForConsumer", true, false);
            }
            catch (JMSException e) {
                LOG.warn((Object)("Failed to set boolean header: " + (Object)((Object)e)), (Throwable)e);
            }
        }
    }
}

