/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import javax.jms.JMSException;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.ActiveMQDispatcher;
import org.apache.activemq.advisory.AdvisorySupport;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQTempDestination;
import org.apache.activemq.command.ConsumerId;
import org.apache.activemq.command.ConsumerInfo;
import org.apache.activemq.command.DataStructure;
import org.apache.activemq.command.DestinationInfo;
import org.apache.activemq.command.MessageAck;
import org.apache.activemq.command.MessageDispatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AdvisoryConsumer
implements ActiveMQDispatcher {
    private static final transient Log LOG = LogFactory.getLog(AdvisoryConsumer.class);
    int deliveredCounter;
    private final ActiveMQConnection connection;
    private ConsumerInfo info;
    private boolean closed;

    public AdvisoryConsumer(ActiveMQConnection connection, ConsumerId consumerId) throws JMSException {
        this.connection = connection;
        this.info = new ConsumerInfo(consumerId);
        this.info.setDestination(AdvisorySupport.TEMP_DESTINATION_COMPOSITE_ADVISORY_TOPIC);
        this.info.setPrefetchSize(1000);
        this.info.setNoLocal(true);
        this.connection.addDispatcher(this.info.getConsumerId(), this);
        this.connection.syncSendPacket(this.info);
    }

    public synchronized void dispose() {
        if (!this.closed) {
            try {
                this.connection.asyncSendPacket(this.info.createRemoveCommand());
            }
            catch (JMSException e) {
                LOG.debug((Object)("Failed to send remove command: " + (Object)((Object)e)), (Throwable)e);
            }
            this.connection.removeDispatcher(this.info.getConsumerId());
            this.closed = true;
        }
    }

    public void dispatch(MessageDispatch md) {
        DataStructure o;
        ++this.deliveredCounter;
        if ((double)this.deliveredCounter > 0.75 * (double)this.info.getPrefetchSize()) {
            try {
                MessageAck ack = new MessageAck(md, 2, this.deliveredCounter);
                this.connection.asyncSendPacket(ack);
                this.deliveredCounter = 0;
            }
            catch (JMSException e) {
                this.connection.onClientInternalException(e);
            }
        }
        if ((o = md.getMessage().getDataStructure()) != null && o.getClass() == DestinationInfo.class) {
            this.processDestinationInfo((DestinationInfo)o);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unexpected message was dispatched to the AdvisoryConsumer: " + md));
        }
    }

    private void processDestinationInfo(DestinationInfo dinfo) {
        ActiveMQDestination dest = dinfo.getDestination();
        if (!dest.isTemporary()) {
            return;
        }
        ActiveMQTempDestination tempDest = (ActiveMQTempDestination)dest;
        if (dinfo.getOperationType() == 0) {
            this.connection.activeTempDestinations.put(tempDest, tempDest);
        } else if (dinfo.getOperationType() == 1) {
            this.connection.activeTempDestinations.remove(tempDest);
        }
    }
}

