/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.net.InetAddress;
import java.util.logging.Level;
import org.compiere.install.Config;
import org.compiere.install.ConfigurationData;

public class ConfigAppServer
extends Config {
    public ConfigAppServer(ConfigurationData data) {
        super(data);
    }

    @Override
    public void init() {
        this.p_data.setAppsServerWebPort("8080");
        this.p_data.setAppsServerWebPort(true);
        this.p_data.setAppsServerSSLPort("8443");
        this.p_data.setAppsServerSSLPort(true);
    }

    @Override
    public String test() {
        String server = this.p_data.getAppsServer();
        boolean pass = server != null && server.length() > 0;
        InetAddress appsServer = null;
        String error = "Not correct: AppsServer = " + server;
        try {
            if (pass) {
                appsServer = InetAddress.getByName(server);
            }
        }
        catch (Exception e) {
            error = String.valueOf(error) + " - " + e.getMessage();
            pass = false;
        }
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okAppsServer, "ErrorAppsServer", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: AppsServer = " + appsServer);
        }
        this.setProperty("ADEMPIERE_APPS_SERVER", appsServer.getHostName());
        int WebPort = this.p_data.getAppsServerWebPort();
        pass = !this.p_data.testPort("http", appsServer.getHostName(), WebPort, "/") && this.p_data.testServerPort(WebPort);
        error = "Not correct: Web Port = " + WebPort;
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okWebPort, "ErrorWebPort", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: Web Port = " + WebPort);
        }
        this.setProperty("ADEMPIERE_WEB_PORT", String.valueOf(WebPort));
        int sslPort = this.p_data.getAppsServerSSLPort();
        pass = !this.p_data.testPort("https", appsServer.getHostName(), sslPort, "/") && this.p_data.testServerPort(sslPort);
        error = "Not correct: SSL Port = " + sslPort;
        if (this.getPanel() != null) {
            this.signalOK(this.getPanel().okSSLPort, "ErrorWebPort", pass, true, error);
        }
        if (!pass) {
            return error;
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("OK: SSL Port = " + sslPort);
        }
        this.setProperty("ADEMPIERE_SSL_PORT", String.valueOf(sslPort));
        return null;
    }
}

