/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MConversionRate;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutGLJournal
extends CalloutEngine {
    public String period(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String colName = mField.getColumnName();
        if (value == null) {
            return "";
        }
        int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Client_ID");
        Timestamp DateAcct = null;
        DateAcct = colName.equals("DateAcct") ? (Timestamp)value : (Timestamp)mTab.getValue("DateAcct");
        int C_Period_ID = 0;
        if (colName.equals("C_Period_ID")) {
            C_Period_ID = (Integer)value;
        }
        if (colName.equals("DateDoc")) {
            mTab.setValue("DateAcct", value);
        } else if (colName.equals("DateAcct")) {
            String sql = "SELECT C_Period_ID FROM C_Period WHERE C_Year_ID IN \t(SELECT C_Year_ID FROM C_Year WHERE C_Calendar_ID =  (SELECT C_Calendar_ID FROM AD_ClientInfo WHERE AD_Client_ID=?)) AND ? BETWEEN StartDate AND EndDate AND IsActive='Y' AND PeriodType='S'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, AD_Client_ID);
                    pstmt.setTimestamp(2, DateAcct);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        C_Period_ID = rs.getInt(1);
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    String string = e.getLocalizedMessage();
                    DB.close(rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
            if (C_Period_ID != 0) {
                mTab.setValue("C_Period_ID", (Object)new Integer(C_Period_ID));
            }
        } else {
            String sql = "SELECT PeriodType, StartDate, EndDate FROM C_Period WHERE C_Period_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement((String)sql, null);
                    pstmt.setInt(1, C_Period_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        String PeriodType = rs.getString(1);
                        Timestamp StartDate = rs.getTimestamp(2);
                        Timestamp EndDate = rs.getTimestamp(3);
                        if (PeriodType.equals("S") && (DateAcct == null || DateAcct.before(StartDate) || DateAcct.after(EndDate))) {
                            mTab.setValue("DateAcct", (Object)EndDate);
                        }
                    }
                }
                catch (SQLException e) {
                    this.log.log(Level.SEVERE, sql, (Throwable)e);
                    String string = e.getLocalizedMessage();
                    DB.close((ResultSet)rs, (Statement)pstmt);
                    rs = null;
                    pstmt = null;
                    return string;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, (Statement)pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close((ResultSet)rs, (Statement)pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }

    public String rate(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        Integer Currency_ID = (Integer)mTab.getValue("C_Currency_ID");
        int C_Currency_ID = Currency_ID;
        Integer ConversionType_ID = (Integer)mTab.getValue("C_ConversionType_ID");
        int C_ConversionType_ID = ConversionType_ID;
        Timestamp DateAcct = (Timestamp)mTab.getValue("DateAcct");
        if (DateAcct == null) {
            DateAcct = new Timestamp(System.currentTimeMillis());
        }
        int C_AcctSchema_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get((Properties)ctx, (int)C_AcctSchema_ID);
        int AD_Client_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Client_ID");
        int AD_Org_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"AD_Org_ID");
        BigDecimal CurrencyRate = MConversionRate.getRate((int)C_Currency_ID, (int)as.getC_Currency_ID(), (Timestamp)DateAcct, (int)C_ConversionType_ID, (int)AD_Client_ID, (int)AD_Org_ID);
        if (this.log.isLoggable(Level.FINE)) {
            this.log.fine("rate = " + CurrencyRate);
        }
        if (CurrencyRate == null) {
            CurrencyRate = Env.ZERO;
        }
        mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        return "";
    }

    public String amt(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal AmtSourceCr;
        BigDecimal AmtSourceDr;
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        int C_AcctSchema_ID = Env.getContextAsInt((Properties)ctx, (int)WindowNo, (String)"C_AcctSchema_ID");
        MAcctSchema as = MAcctSchema.get((Properties)ctx, (int)C_AcctSchema_ID);
        int Precision = as.getStdPrecision();
        BigDecimal CurrencyRate = (BigDecimal)mTab.getValue("CurrencyRate");
        if (CurrencyRate == null) {
            CurrencyRate = Env.ONE;
            mTab.setValue("CurrencyRate", (Object)CurrencyRate);
        }
        if ((AmtSourceDr = (BigDecimal)mTab.getValue("AmtSourceDr")) == null) {
            AmtSourceDr = Env.ZERO;
        }
        if ((AmtSourceCr = (BigDecimal)mTab.getValue("AmtSourceCr")) == null) {
            AmtSourceCr = Env.ZERO;
        }
        BigDecimal AmtAcctDr = AmtSourceDr.multiply(CurrencyRate);
        AmtAcctDr = AmtAcctDr.setScale(Precision, 4);
        mTab.setValue("AmtAcctDr", (Object)AmtAcctDr);
        BigDecimal AmtAcctCr = AmtSourceCr.multiply(CurrencyRate);
        AmtAcctCr = AmtAcctCr.setScale(Precision, 4);
        mTab.setValue("AmtAcctCr", (Object)AmtAcctCr);
        return "";
    }

    public String account(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String colName = mField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        if (colName.equals("Account_ID") || colName.equals("C_SubAcct_ID") || colName.equals("M_Product_ID") || colName.equals("C_BPartner_ID") || colName.equals("AD_OrgTrx_ID") || colName.equals("AD_Org_ID") || colName.equals("C_LocFrom_ID") || colName.equals("C_LocTo_ID") || colName.equals("C_SalesRegion_ID") || colName.equals("C_Project_ID") || colName.equals("C_Campaign_ID") || colName.equals("C_Activity_ID") || colName.equals("User1_ID") || colName.equals("User2_ID") || colName.equals("UserElement1_ID") || colName.equals("UserElement2_ID")) {
            mTab.setValue("C_ValidCombination_ID", null);
            mTab.setValue("Alias_ValidCombination_ID", null);
        }
        return "";
    }

    public String alias(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        String colName = mField.getColumnName();
        if (value == null || this.isCalloutActive()) {
            return "";
        }
        Integer Combi_ID = (int)((Integer)value);
        if (colName.equals("Alias_ValidCombination_ID")) {
            mTab.setValue("C_ValidCombination_ID", (Object)Combi_ID);
        }
        if (colName.equals("C_ValidCombination_ID")) {
            mTab.setValue("Alias_ValidCombination_ID", (Object)Combi_ID);
        }
        if (colName.equals("C_ValidCombination_ID") || colName.equals("Alias_ValidCombination_ID")) {
            MAccount combi = new MAccount(ctx, Combi_ID.intValue(), null);
            mTab.setValue("Account_ID", combi.getAccount_ID() != 0 ? Integer.valueOf(combi.getAccount_ID()) : null);
            mTab.setValue("C_SubAcct_ID", combi.getC_SubAcct_ID() != 0 ? Integer.valueOf(combi.getC_SubAcct_ID()) : null);
            mTab.setValue("M_Product_ID", combi.getM_Product_ID() != 0 ? Integer.valueOf(combi.getM_Product_ID()) : null);
            mTab.setValue("C_BPartner_ID", combi.getC_BPartner_ID() != 0 ? Integer.valueOf(combi.getC_BPartner_ID()) : null);
            mTab.setValue("AD_OrgTrx_ID", combi.getAD_OrgTrx_ID() != 0 ? Integer.valueOf(combi.getAD_OrgTrx_ID()) : null);
            mTab.setValue("AD_Org_ID", combi.getAD_Org_ID() != 0 ? Integer.valueOf(combi.getAD_Org_ID()) : null);
            mTab.setValue("C_LocFrom_ID", combi.getC_LocFrom_ID() != 0 ? Integer.valueOf(combi.getC_LocFrom_ID()) : null);
            mTab.setValue("C_LocTo_ID", combi.getC_LocTo_ID() != 0 ? Integer.valueOf(combi.getC_LocTo_ID()) : null);
            mTab.setValue("C_SalesRegion_ID", combi.getC_SalesRegion_ID() != 0 ? Integer.valueOf(combi.getC_SalesRegion_ID()) : null);
            mTab.setValue("C_Project_ID", combi.getC_Project_ID() != 0 ? Integer.valueOf(combi.getC_Project_ID()) : null);
            mTab.setValue("C_Campaign_ID", combi.getC_Campaign_ID() != 0 ? Integer.valueOf(combi.getC_Campaign_ID()) : null);
            mTab.setValue("C_Activity_ID", combi.getC_Activity_ID() != 0 ? Integer.valueOf(combi.getC_Activity_ID()) : null);
            mTab.setValue("User1_ID", combi.getUser1_ID() != 0 ? Integer.valueOf(combi.getUser1_ID()) : null);
            mTab.setValue("User2_ID", combi.getUser2_ID() != 0 ? Integer.valueOf(combi.getUser2_ID()) : null);
            mTab.setValue("UserElement1_ID", combi.getUserElement1_ID() != 0 ? Integer.valueOf(combi.getUserElement1_ID()) : null);
            mTab.setValue("UserElement2_ID", combi.getUserElement2_ID() != 0 ? Integer.valueOf(combi.getUserElement2_ID()) : null);
        }
        return "";
    }
}

