/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.VerticalLayout;

public class StackedBox
extends JPanel
implements Scrollable {
    private static final long serialVersionUID = -8233461475245242991L;
    private Color titleBackgroundColor;
    private Color titleForegroundColor;
    private Color separatorColor;
    private Border separatorBorder;

    public StackedBox() {
        this.setLayout((LayoutManager)new VerticalLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.separatorBorder = new SeparatorBorder();
        this.setTitleForegroundColor(Color.BLACK);
        this.setTitleBackgroundColor(new Color(248, 248, 248));
        this.setSeparatorColor(new Color(214, 223, 247));
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public Color getTitleForegroundColor() {
        return this.titleForegroundColor;
    }

    public void setTitleForegroundColor(Color titleForegroundColor) {
        this.titleForegroundColor = titleForegroundColor;
    }

    public Color getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleBackgroundColor(Color titleBackgroundColor) {
        this.titleBackgroundColor = titleBackgroundColor;
    }

    public void addBox(String title, Component component) {
        JXCollapsiblePane collapsible = new JXCollapsiblePane();
        collapsible.getContentPane().setBackground(Color.WHITE);
        collapsible.add(component);
        collapsible.setBorder((Border)new CompoundBorder(this.separatorBorder, collapsible.getBorder()));
        Action toggleAction = collapsible.getActionMap().get("toggle");
        toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon"));
        toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon"));
        JXHyperlink link = new JXHyperlink(toggleAction);
        link.setText(title);
        link.setFont(link.getFont().deriveFont(1));
        link.setOpaque(true);
        link.setBackground(this.getTitleBackgroundColor());
        link.setFocusPainted(false);
        link.setUnclickedColor(this.getTitleForegroundColor());
        link.setClickedColor(this.getTitleForegroundColor());
        link.setBorder((Border)new CompoundBorder(this.separatorBorder, BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        link.setBorderPainted(true);
        this.add((Component)link);
        this.add((Component)collapsible);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    class SeparatorBorder
    implements Border {
        SeparatorBorder() {
        }

        boolean isFirst(Component c) {
            return c.getParent() == null || c.getParent().getComponent(0) == c;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (c instanceof JXCollapsiblePane && ((JXCollapsiblePane)c).isCollapsed()) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(this.isFirst(c) ? 4 : 1, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(StackedBox.this.getSeparatorColor());
            if (this.isFirst(c)) {
                g.drawLine(x, y + 2, x + width, y + 2);
            }
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }
}

