/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import org.adempiere.plaf.AdempierePLAF;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.VerticalLayout;

public class CollapsiblePanel
extends JPanel {
    private static final long serialVersionUID = -7372966868790589720L;
    private Color titleBackgroundColor;
    private Color titleForegroundColor;
    private Color separatorColor;
    private Border separatorBorder;
    private JXHyperlink link;
    private JXCollapsiblePane collapsible;

    public CollapsiblePanel(String title) {
        this.setLayout((LayoutManager)new VerticalLayout());
        this.setOpaque(true);
        this.setBackground(Color.WHITE);
        this.separatorBorder = new SeparatorBorder();
        this.setTitleForegroundColor(Color.BLACK);
        this.setTitleBackgroundColor(new Color(248, 248, 248));
        this.setSeparatorColor(new Color(214, 223, 247));
        this.collapsible = new JXCollapsiblePane();
        this.collapsible.getContentPane().setBackground(AdempierePLAF.getFormBackground());
        this.collapsible.setBorder((Border)new CompoundBorder(this.separatorBorder, this.collapsible.getBorder()));
        Action toggleAction = this.collapsible.getActionMap().get("toggle");
        toggleAction.putValue("collapseIcon", UIManager.getIcon("Tree.expandedIcon"));
        toggleAction.putValue("expandIcon", UIManager.getIcon("Tree.collapsedIcon"));
        this.link = new JXHyperlink(toggleAction);
        this.link.setText(title);
        this.link.setOpaque(true);
        this.link.setBackground(this.getTitleBackgroundColor());
        this.link.setFocusPainted(false);
        this.link.setUnclickedColor(this.getTitleForegroundColor());
        this.link.setClickedColor(this.getTitleForegroundColor());
        this.link.setBorder((Border)new CompoundBorder(this.separatorBorder, BorderFactory.createEmptyBorder(2, 4, 2, 4)));
        this.link.setBorderPainted(true);
        super.add((Component)this.link);
        super.add((Component)this.collapsible);
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        this.separatorColor = separatorColor;
    }

    public Color getTitleForegroundColor() {
        return this.titleForegroundColor;
    }

    public void setTitleForegroundColor(Color titleForegroundColor) {
        this.titleForegroundColor = titleForegroundColor;
    }

    public Color getTitleBackgroundColor() {
        return this.titleBackgroundColor;
    }

    public void setTitleBackgroundColor(Color titleBackgroundColor) {
        this.titleBackgroundColor = titleBackgroundColor;
    }

    public void setTitle(String title) {
        if (this.link != null) {
            this.link.setText(title);
        }
    }

    public JXCollapsiblePane getCollapsiblePane() {
        return this.collapsible;
    }

    @Override
    public Component add(Component comp) {
        if (this.collapsible != null) {
            return this.collapsible.add(comp);
        }
        return null;
    }

    class SeparatorBorder
    implements Border {
        SeparatorBorder() {
        }

        boolean isFirst(Component c) {
            return c.getParent() == null || c.getParent().getComponent(0) == c;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            if (c instanceof JXCollapsiblePane && ((JXCollapsiblePane)c).isCollapsed()) {
                return new Insets(0, 0, 0, 0);
            }
            return new Insets(4, 0, 1, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (c instanceof JXCollapsiblePane && ((JXCollapsiblePane)c).isCollapsed()) {
                return;
            }
            g.setColor(CollapsiblePanel.this.getSeparatorColor());
            if (this.isFirst(c)) {
                g.drawLine(x, y + 2, x + width, y + 2);
            }
            g.drawLine(x, y + height - 1, x + width, y + height - 1);
        }
    }
}

