/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.plaf;

import java.awt.Color;
import java.awt.Component;
import javax.swing.UIDefaults;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.compiere.plaf.CompiereTheme;
import org.compiere.plaf.CompiereThemeBlueMetal;

public class CompiereLookAndFeel
extends MetalLookAndFeel {
    private static final long serialVersionUID = -5141712405407428104L;
    public static final String NAME = "Compiere";
    private static CompiereTheme s_compiereTheme = new CompiereThemeBlueMetal();
    private static MetalTheme s_theme = s_compiereTheme;
    protected static boolean ROUND = false;
    public static final String BACKGROUND = "CompiereBackground";
    public static final String BACKGROUND_FILL = "CompiereBackgroundFill";
    public static final String TABLEVEL = "TabLevel";
    public static final String VERSION = "R1.4.0";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "Compiere Look & Feel - (c) 2001-2005 Jorg Janke";
    }

    @Override
    public UIDefaults getDefaults() {
        MetalLookAndFeel.setCurrentTheme(s_theme);
        UIDefaults defaults = super.getDefaults();
        return defaults;
    }

    @Override
    protected void initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        this.putDefault(table, "PanelUI");
        this.putDefault(table, "ButtonUI");
        this.putDefault(table, "ToggleButtonUI");
        this.putDefault(table, "TabbedPaneUI");
        this.putDefault(table, "TableHeaderUI");
        this.putDefault(table, "RadioButtonUI");
        this.putDefault(table, "CheckBoxUI");
        this.putDefault(table, "ComboBoxUI");
        this.putDefault(table, "MenuUI");
        this.putDefault(table, "MenuBarUI");
        this.putDefault(table, "MenuItemUI");
        this.putDefault(table, "CheckBoxMenuItemUI");
        this.putDefault(table, "ToolBarUI");
        this.putDefault(table, "RootPaneUI");
        this.putDefault(table, "ViewportUI");
        this.putDefault(table, "SplitPaneUI");
        this.putDefault(table, "ScrollPaneUI");
        this.putDefault(table, "LabelUI");
        this.putDefault(table, "ToolTipUI");
        this.putDefault(table, "TextAreaUI");
    }

    private void putDefault(UIDefaults table, String uiKey) {
        try {
            String className = "org.compiere.plaf.Compiere" + uiKey;
            table.put(uiKey, className);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults table) {
        super.initSystemColorDefaults(table);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        Color c = table.getColor("TextField.background");
        table.put("ComboBox.background", c);
        table.put("ComboBox.listBackground", c);
    }

    @Override
    protected void createDefaultTheme() {
        CompiereLookAndFeel.setCurrentTheme(s_theme);
    }

    public static void setCurrentTheme(MetalTheme theme) {
        if (theme != null) {
            s_theme = theme;
        }
        MetalLookAndFeel.setCurrentTheme(s_theme);
    }

    public static MetalTheme getCurrentTheme() {
        return s_theme;
    }

    public static CompiereTheme getCompiereTheme() {
        return s_compiereTheme;
    }

    @Override
    public void provideErrorFeedback(Component component) {
        super.provideErrorFeedback(component);
    }
}

