/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.util.List;
import org.adempiere.base.Service;
import org.adempiere.ui.swing.factory.IEditorFactory;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;

public class VEditorFactory {
    private static CLogger log = CLogger.getCLogger(VEditorFactory.class);

    public static VEditor getEditor(GridField mField, boolean tableEditor) {
        return VEditorFactory.getEditor(null, mField, tableEditor);
    }

    public static VEditor getEditor(GridTab mTab, GridField mField, boolean tableEditor) {
        VEditor editor = null;
        List factoryList = Service.locator().list(IEditorFactory.class).getServices();
        for (IEditorFactory factory : factoryList) {
            editor = factory.getEditor(mTab, mField, tableEditor);
            if (editor != null) break;
        }
        return editor;
    }

    public static CLabel getLabel(GridField mField) {
        if (mField == null) {
            return null;
        }
        int displayType = mField.getDisplayType();
        if (mField.isFieldOnly() || displayType == 20 || displayType == 28) {
            return null;
        }
        CLabel label = new CLabel(mField.getHeader(), mField.getDescription());
        label.setName(mField.getColumnName());
        return label;
    }
}

