/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.util.Properties;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.compiere.apps.FieldRecordInfo;
import org.compiere.grid.ed.VEditor;
import org.compiere.model.GridField;
import org.compiere.swing.CCheckBox;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCheckBox
extends CCheckBox
implements VEditor,
ActionListener {
    private static final long serialVersionUID = -3840182999009176708L;
    private char m_savedMnemonic = '\u0000';
    private String m_columnName;
    private GridField m_mField;
    JPopupMenu popupMenu = new JPopupMenu();

    public VCheckBox() {
        this("", false, false, true, "", null, false);
    }

    public VCheckBox(String columnName, boolean mandatory, boolean isReadOnly, boolean isUpdateable, String title, String description, boolean tableEditor) {
        super.setName(columnName);
        this.m_columnName = columnName;
        this.setMandatory(mandatory);
        if (isReadOnly || !isUpdateable) {
            this.setEditable(false);
        } else {
            this.setEditable(true);
        }
        if (!tableEditor) {
            this.setText(title);
            if (description != null && description.length() > 0) {
                this.setToolTipText(description);
            }
        } else {
            this.setHorizontalAlignment(0);
        }
        this.addActionListener(this);
        this.addMouseListener(new VCheckBox_mouseAdapter(this));
    }

    @Override
    public void dispose() {
    }

    public void setEditable(boolean value) {
        super.setReadWrite(value);
    }

    public boolean isEditable() {
        return super.isReadWrite();
    }

    @Override
    public void setValue(Object value) {
        boolean sel = false;
        if (value != null) {
            sel = value instanceof Boolean ? ((Boolean)value).booleanValue() : "Y".equals(value);
        }
        this.setSelected(sel);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            this.setValue(evt.getNewValue());
        }
    }

    @Override
    public Object getValue() {
        return new Boolean(this.isSelected());
    }

    @Override
    public String getDisplay() {
        String value = this.isSelected() ? "Y" : "N";
        return Msg.translate((Properties)Env.getCtx(), (String)value);
    }

    public void setBackground() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("ChangeLog")) {
            FieldRecordInfo.start(this.m_mField);
            return;
        }
        try {
            this.fireVetoableChange(this.m_columnName, null, this.getValue());
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    @Override
    public void setField(GridField mField) {
        this.m_mField = mField;
        if (this.m_mField != null) {
            FieldRecordInfo.addMenu(this, this.popupMenu);
        }
    }

    @Override
    public GridField getField() {
        return this.m_mField;
    }

    public char getSavedMnemonic() {
        return this.m_savedMnemonic;
    }

    public void setSavedMnemonic(char savedMnemonic) {
        this.m_savedMnemonic = savedMnemonic;
    }

    @Override
    public Component getFocusableComponent() {
        return this;
    }

    final class VCheckBox_mouseAdapter
    extends MouseAdapter {
        private VCheckBox m_adaptee;

        VCheckBox_mouseAdapter(VCheckBox adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

