/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.JLabel;
import javax.swing.table.DefaultTableModel;
import org.compiere.apps.AEnv;
import org.compiere.grid.CreateFrom;
import org.compiere.grid.CreateFromRMA;
import org.compiere.grid.VCreateFromDialog;
import org.compiere.grid.ed.VLookup;
import org.compiere.model.GridTab;
import org.compiere.model.Lookup;
import org.compiere.model.MLookup;
import org.compiere.model.MLookupFactory;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class VCreateFromRMAUI
extends CreateFromRMA
implements VetoableChangeListener {
    private VCreateFromDialog dialog;
    private int p_WindowNo;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private JLabel bPartnerLabel = new JLabel();
    private VLookup bPartnerField;

    public VCreateFromRMAUI(GridTab mTab) {
        super(mTab);
        if (this.log.isLoggable(Level.INFO)) {
            this.log.info(this.getGridTab().toString());
        }
        this.dialog = new VCreateFromDialog((CreateFrom)this, this.getGridTab().getWindowNo(), true);
        this.p_WindowNo = this.getGridTab().getWindowNo();
        try {
            if (!this.dynInit()) {
                return;
            }
            this.jbInit();
            this.setInitOK(true);
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", (Throwable)e);
            this.setInitOK(false);
        }
        AEnv.positionCenterWindow(AEnv.getWindow(this.p_WindowNo), this.dialog);
    }

    public boolean dynInit() throws Exception {
        this.log.config("");
        super.dynInit();
        this.dialog.setTitle(this.getTitle());
        this.initBPartner(true);
        this.bPartnerField.addVetoableChangeListener(this);
        this.loadRMA();
        return true;
    }

    private void jbInit() throws Exception {
        this.bPartnerLabel.setText(Msg.getElement((Properties)Env.getCtx(), (String)"C_BPartner_ID"));
        CPanel parameterPanel = this.dialog.getParameterPanel();
        parameterPanel.setLayout(new BorderLayout());
        CPanel parameterStdPanel = new CPanel(new GridBagLayout());
        parameterPanel.add((Component)parameterStdPanel, "Center");
        parameterStdPanel.add((Component)this.bPartnerLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        if (this.bPartnerField != null) {
            parameterStdPanel.add((Component)this.bPartnerField, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 5, 5), 0, 0));
        }
    }

    @Override
    public void vetoableChange(PropertyChangeEvent e) {
        if (this.log.isLoggable(Level.CONFIG)) {
            this.log.config(String.valueOf(e.getPropertyName()) + "=" + e.getNewValue());
        }
        if (e.getPropertyName().equals("C_BPartner_ID")) {
            this.loadRMA();
        }
        this.dialog.tableChanged(null);
    }

    protected void initBPartner(boolean forInvoice) throws Exception {
        int AD_Column_ID = 3499;
        MLookup lookup = MLookupFactory.get((Properties)Env.getCtx(), (int)this.p_WindowNo, (int)0, (int)AD_Column_ID, (int)30);
        this.bPartnerField = new VLookup("C_BPartner_ID", true, false, true, (Lookup)lookup);
        int C_BPartner_ID = Env.getContextAsInt((Properties)Env.getCtx(), (int)this.p_WindowNo, (String)"C_BPartner_ID");
        this.bPartnerField.setValue(new Integer(C_BPartner_ID));
    }

    protected void loadRMA() {
        this.loadTableOIS(this.getRMAData());
    }

    protected void loadTableOIS(Vector<?> data) {
        this.dialog.getMiniTable().getModel().removeTableModelListener(this.dialog);
        DefaultTableModel model = new DefaultTableModel(data, this.getOISColumnNames());
        model.addTableModelListener(this.dialog);
        this.dialog.getMiniTable().setModel(model);
        this.configureMiniTable(this.dialog.getMiniTable());
    }

    public void showWindow() {
        this.dialog.setVisible(true);
    }

    public void closeWindow() {
        this.dialog.dispose();
    }

    public Object getWindow() {
        return this.dialog;
    }
}

