/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.font.TextLayout;
import java.sql.Timestamp;
import java.util.logging.Level;
import javax.swing.JComponent;
import org.compiere.model.MAssignmentSlot;
import org.compiere.plaf.CompiereUtils;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class VScheduleTimePanel
extends JComponent {
    private static final long serialVersionUID = 2498994787352243360L;
    private MAssignmentSlot[] m_timeSlots = null;
    private String[] m_lines = new String[]{""};
    public static int LINE_HEIGHT = 35;
    public static int HEADING = 25;
    private Font m_font = new Font("serif", 0, 12);
    private int m_width = 120;
    private static CLogger log = CLogger.getCLogger(VScheduleTimePanel.class);

    public VScheduleTimePanel() {
        this.setOpaque(false);
        this.setSize();
    }

    public void setTimeSlots(MAssignmentSlot[] timeSlots) {
        log.fine("VScheduleTimePanel.setTimeSlots");
        this.m_timeSlots = timeSlots;
        this.m_lines = new String[this.m_timeSlots.length];
        FontMetrics fm = null;
        Graphics g = this.getGraphics();
        if (g == null) {
            g = Env.getGraphics((Container)this);
        }
        if (g != null) {
            fm = g.getFontMetrics(this.m_font);
        } else {
            log.log(Level.SEVERE, "No Graphics");
        }
        this.m_width = 0;
        int i = 0;
        while (i < this.m_lines.length) {
            this.m_lines[i] = this.m_timeSlots[i].getInfoTimeFrom();
            int width = 0;
            if (fm != null) {
                width = fm.stringWidth(this.m_lines[i]);
            }
            if (width > this.m_width) {
                this.m_width = width;
            }
            ++i;
        }
        this.setSize();
    }

    private void setSize() {
        int width = this.m_width + 10;
        if (width <= 10) {
            width = 120;
        }
        int height = LINE_HEIGHT;
        int lines = this.m_lines.length;
        height = lines < 2 ? (height *= 10) : (height *= lines);
        Dimension size = new Dimension(width, height += HEADING);
        this.setPreferredSize(size);
        this.setMinimumSize(size);
        this.setMaximumSize(size);
    }

    public int getHeaderHeight() {
        return HEADING;
    }

    public int getSlotHeight() {
        int height = this.getPreferredSize().height;
        int part = (height - HEADING) / this.m_lines.length;
        return part;
    }

    public int getSlotCount() {
        return this.m_lines.length;
    }

    public int getSlotYStart(int slot) {
        int part = this.getSlotHeight();
        int y = HEADING + slot * part;
        return y;
    }

    public int getSlotYEnd(int slot) {
        int part = this.getSlotHeight();
        int y = HEADING + (slot + 1) * part;
        return y;
    }

    public int getTimeSlotIndex(Timestamp time, boolean endTime) {
        if (this.m_timeSlots.length <= 1) {
            return 0;
        }
        int i = 0;
        while (i < this.m_timeSlots.length) {
            if (this.m_timeSlots[i].inSlot(time, endTime)) {
                return i;
            }
            ++i;
        }
        log.log(Level.SEVERE, "VScheduleTimePanel.getSlotIndex - did not find Slot for " + time + " end=" + endTime);
        return 0;
    }

    public MAssignmentSlot getTimeSlot(int index) {
        if (index < 0 || index > this.m_timeSlots.length) {
            return null;
        }
        return this.m_timeSlots[index];
    }

    public int getTimeSlotIndex(int yPos) {
        int index = yPos - this.getHeaderHeight();
        if ((index /= this.getSlotHeight()) < 0) {
            return 0;
        }
        if (index >= this.m_timeSlots.length) {
            return this.m_timeSlots.length - 1;
        }
        return index;
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2D = (Graphics2D)g;
        g2D.setFont(this.m_font);
        Dimension size = this.getPreferredSize();
        int w = size.width;
        int h = size.height;
        g2D.setPaint(Color.white);
        g2D.fill3DRect(1, 1, w - 2, h - 2, true);
        Rectangle where = new Rectangle(0, 0, w, this.getHeaderHeight());
        CompiereUtils.paint3Deffect(g2D, where, false, true);
        TextLayout layout = null;
        g2D.setStroke(VScheduleTimePanel.getStroke(true));
        int i = 0;
        while (i < this.m_lines.length) {
            int yy = this.getSlotYStart(i);
            if (this.m_lines[i] != null && this.m_lines[i].length() > 0) {
                layout = new TextLayout(this.m_lines[i], this.m_font, g2D.getFontRenderContext());
                g2D.setPaint(Color.blue);
                layout.draw(g2D, (float)w - layout.getAdvance() - 3.0f, (float)yy + layout.getAscent() + layout.getLeading());
            }
            g2D.setPaint(Color.gray);
            g2D.drawLine(2, yy, w - 2, yy);
            ++i;
        }
        g2D.setPaint(Color.black);
        g2D.setStroke(VScheduleTimePanel.getStroke(false));
        g2D.drawLine(1, 1, 1, h - 1);
        g2D.drawLine(w - 1, 1, w - 1, h - 1);
        g2D.drawLine(1, 1, w - 1, 1);
        g2D.drawLine(1, this.getHeaderHeight(), w - 1, this.getHeaderHeight());
        g2D.drawLine(1, h - 1, w - 1, h - 1);
    }

    public static Stroke getStroke(boolean slotLine) {
        if (slotLine) {
            return new BasicStroke(1.0f, 0, 0, 1.0f, new float[]{2.0f, 0.5f}, 0.0f);
        }
        return new BasicStroke(1.0f);
    }
}

