/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.grid.ed.VText;
import org.compiere.swing.CButton;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextArea;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class VSQLProcess
extends CPanel
implements FormPanel,
ActionListener {
    private static final long serialVersionUID = -8445688937366388495L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private static CLogger log = CLogger.getCLogger(VSQLProcess.class);
    private static final String[] DML_KEYWORDS = new String[]{"SELECT", "UPDATE", "DELETE", "TRUNCATE"};
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private CLabel sqlLabel = new CLabel("SQL");
    private VText sqlField = new VText("SQL", false, false, true, 3000, 9000);
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private BorderLayout northLayout = new BorderLayout();
    private CTextArea resultField = new CTextArea(20, 60);
    private CButton sqlButton = ConfirmPanel.createProcessButton(true);

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("VSQLProcess.init");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            frame.getContentPane().add((Component)this, "Center");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VSQLProcess.init", (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    void jbInit() throws Exception {
        this.setLayout(this.mainLayout);
        this.mainLayout.setHgap(5);
        this.mainLayout.setVgap(5);
        this.add((Component)this.northPanel, "North");
        this.northLayout.setHgap(5);
        this.northLayout.setVgap(5);
        this.northPanel.setLayout(this.northLayout);
        this.sqlLabel.setText("SQL");
        this.northPanel.add((Component)this.sqlLabel, "West");
        this.northPanel.add((Component)this.sqlField, "Center");
        this.sqlButton.addActionListener(this);
        this.northPanel.add((Component)this.sqlButton, "East");
        this.add((Component)this.centerPanel, "Center");
        this.centerPanel.setLayout(this.centerLayout);
        this.centerLayout.setHgap(0);
        this.resultField.setReadWrite(false);
        this.centerPanel.add((Component)this.resultField, "Center");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.resultField.setText(VSQLProcess.processStatements(this.sqlField.getText(), false));
    }

    public static String processStatements(String sqlStatements, boolean allowDML) {
        if (sqlStatements == null || sqlStatements.length() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        StringTokenizer st = new StringTokenizer(sqlStatements, ";", false);
        while (st.hasMoreTokens()) {
            result.append(VSQLProcess.processStatement(st.nextToken(), allowDML));
            result.append(Env.NL);
        }
        return result.toString();
    }

    public static String processStatement(String sqlStatement, boolean allowDML) {
        StringBuffer result;
        block22: {
            if (sqlStatement == null) {
                return "";
            }
            StringBuilder sb = new StringBuilder();
            char[] chars = sqlStatement.toCharArray();
            int i = 0;
            while (i < chars.length) {
                char c = chars[i];
                if (Character.isWhitespace(c)) {
                    sb.append(' ');
                } else {
                    sb.append(c);
                }
                ++i;
            }
            String sql = sb.toString().trim();
            if (sql.length() == 0) {
                return "";
            }
            result = new StringBuffer("SQL> ").append(sql).append(Env.NL);
            if (!allowDML) {
                boolean error = false;
                String SQL = sql.toUpperCase();
                int i2 = 0;
                while (i2 < DML_KEYWORDS.length) {
                    if (SQL.startsWith(String.valueOf(DML_KEYWORDS[i2]) + " ") || SQL.indexOf(" " + DML_KEYWORDS[i2] + " ") != -1 || SQL.indexOf("(" + DML_KEYWORDS[i2] + " ") != -1) {
                        result.append("===> ERROR: Not Allowed Keyword ").append(DML_KEYWORDS[i2]).append(Env.NL);
                        error = true;
                    }
                    ++i2;
                }
                if (error) {
                    return result.toString();
                }
            }
            Connection conn = DB.createConnection((boolean)true, (int)2);
            Statement stmt = null;
            try {
                try {
                    stmt = conn.createStatement();
                    boolean OK = stmt.execute(sql);
                    int count = stmt.getUpdateCount();
                    if (count == -1) {
                        result.append("---> ResultSet");
                    } else {
                        result.append("---> Result=").append(count);
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "process statement: " + sql + " - " + e.toString());
                    result.append("===> ").append(e.toString());
                    DB.close((Statement)stmt);
                    stmt = null;
                    try {
                        conn.close();
                    }
                    catch (SQLException e2) {
                        log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
                    }
                    conn = null;
                    break block22;
                }
            }
            catch (Throwable throwable) {
                DB.close((Statement)stmt);
                stmt = null;
                try {
                    conn.close();
                }
                catch (SQLException e2) {
                    log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
                }
                conn = null;
                throw throwable;
            }
            DB.close((Statement)stmt);
            stmt = null;
            try {
                conn.close();
            }
            catch (SQLException e2) {
                log.log(Level.SEVERE, "processStatement - close connection", (Throwable)e2);
            }
            conn = null;
        }
        result.append(Env.NL);
        return result.toString();
    }
}

