/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.IStatusBar;
import org.compiere.apps.StatusBar;
import org.compiere.apps.form.CreateFromForm;
import org.compiere.apps.form.FormFrame;
import org.compiere.minigrid.IMiniTable;
import org.compiere.minigrid.MiniTable;
import org.compiere.swing.CPanel;
import org.compiere.swing.CToggleButton;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Trx;
import org.compiere.util.TrxRunnable;

public class VCreateFromForm
extends CPanel
implements ActionListener,
TableModelListener {
    private static final long serialVersionUID = -8242250391030501785L;
    private CreateFromForm form;
    private int windowNo;
    private FormFrame m_frame;
    private CPanel parameterPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private StatusBar statusBar = new StatusBar();
    private MiniTable dataTable = new MiniTable();
    private static final String SELECT_DESELECT_ALL = "SelectAll";
    protected AppsAction selectDeselectAllAction = new AppsAction("SelectAll", null, Msg.getMsg((Properties)Env.getCtx(), (String)"SelectAll"), true);

    public VCreateFromForm(CreateFromForm createFrom, FormFrame frame) {
        this.form = createFrom;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.confirmPanel.addActionListener(this);
            this.statusBar.setStatusDB("");
            this.tableChanged(null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void jbInit() throws Exception {
        this.m_frame.getContentPane().add((Component)this.parameterPanel, "North");
        JScrollPane dataPane = new JScrollPane();
        this.m_frame.getContentPane().add((Component)dataPane, "Center");
        dataPane.getViewport().add((Component)this.dataTable, null);
        CToggleButton selectAllButton = (CToggleButton)this.selectDeselectAllAction.getButton();
        selectAllButton.setMargin(ConfirmPanel.s_insets);
        selectAllButton.addActionListener(this);
        this.confirmPanel.addComponent(selectAllButton);
        CPanel southPanel = new CPanel();
        this.m_frame.getContentPane().add((Component)southPanel, "South");
        BorderLayout southLayout = new BorderLayout();
        southPanel.setLayout(southLayout);
        southPanel.add((Component)this.confirmPanel, "Center");
        southPanel.add((Component)this.statusBar, "South");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("Ok")) {
            try {
                Trx.run((TrxRunnable)new TrxRunnable(){

                    public void run(String trxName) {
                        if (VCreateFromForm.this.save(trxName)) {
                            VCreateFromForm.this.dispose();
                        }
                    }
                });
            }
            catch (Exception ex) {
                ADialog.error(this.windowNo, this, "Error", ex.getLocalizedMessage());
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        } else if (e.getActionCommand().equals(SELECT_DESELECT_ALL)) {
            TableModel model = this.dataTable.getModel();
            model.removeTableModelListener(this);
            int rows = model.getRowCount();
            Boolean selectAll = this.selectDeselectAllAction.isPressed() ? Boolean.FALSE : Boolean.TRUE;
            int i = 0;
            while (i < rows) {
                model.setValueAt(selectAll, i, 0);
                ++i;
            }
            model.addTableModelListener(this);
            this.info();
        }
    }

    public boolean save(String trxName) {
        this.dataTable.stopEditor(true);
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        if (rows == 0) {
            return false;
        }
        return this.form.save((IMiniTable)this.dataTable, trxName, this.m_frame.getGridTab());
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int type = -1;
        if (e != null) {
            type = e.getType();
            if (type != 0) {
                return;
            }
            if (e.getColumn() == 0) {
                TableModel model = this.dataTable.getModel();
                Boolean isPressed = (Boolean)model.getValueAt(0, 0);
                int rows = model.getRowCount();
                boolean equals = true;
                int i = 1;
                while (equals && i < rows) {
                    equals = isPressed.equals(model.getValueAt(i, 0));
                    ++i;
                }
                if (equals) {
                    this.selectDeselectAllAction.setPressed(isPressed);
                }
            }
        }
        this.info();
        this.dataTable.repaint();
    }

    public void info() {
        TableModel model = this.dataTable.getModel();
        int rows = model.getRowCount();
        int count = 0;
        int i = 0;
        while (i < rows) {
            if (((Boolean)model.getValueAt(i, 0)).booleanValue()) {
                ++count;
            }
            ++i;
        }
        this.setStatusLine(count, null);
        this.form.info((IMiniTable)this.dataTable, (IStatusBar)this.statusBar);
    }

    public void setStatusLine(int selectedRowCount, String text) {
        StringBuilder sb = new StringBuilder(String.valueOf(selectedRowCount));
        if (text != null && text.trim().length() > 0) {
            sb.append(" - ").append(text);
        }
        this.statusBar.setStatusLine(sb.toString());
        this.confirmPanel.getOKButton().setEnabled(selectedRowCount > 0);
    }

    public MiniTable getMiniTable() {
        return this.dataTable;
    }

    public CPanel getParameterPanel() {
        return this.parameterPanel;
    }

    public ConfirmPanel getConfirmPanel() {
        return this.confirmPanel;
    }

    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }
}

