/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import groovy.lang.GroovyShell;
import groovy.ui.ConsoleTextEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.Help;
import org.compiere.model.MUser;
import org.compiere.swing.CDialog;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class GroovyEditor
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = 2941209813417292930L;
    private Frame m_owner;
    private String m_script;
    private int m_WindowNo;
    private String m_origScript;
    private static CLogger log = CLogger.getCLogger(GroovyEditor.class);
    private CPanel mainPanel = new CPanel();
    private BorderLayout borderLayout1 = new BorderLayout();
    private JScrollPane editorPane = new JScrollPane();
    private ConsoleTextEditor editor = new ConsoleTextEditor();
    private TitledBorder titledBorder2;
    private CPanel southPanel = new CPanel();
    private BorderLayout southLayout = new BorderLayout();
    private CPanel okPanel = new CPanel();
    private JButton bOK = ConfirmPanel.createOKButton(true);
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private CPanel resultPanel = new CPanel();
    private JButton bProcess = ConfirmPanel.createProcessButton(true);
    private JButton bHelp = ConfirmPanel.createHelpButton(true);
    private JLabel lResult = new JLabel();
    private JTextField fResult = new JTextField();
    private FlowLayout okLayout = new FlowLayout();
    private GridBagLayout resultLayout = new GridBagLayout();

    public GroovyEditor() {
        this(Msg.getMsg((Properties)Env.getCtx(), (String)"Script"), null, 0);
    }

    public GroovyEditor(Frame owner) {
        this(owner, Msg.getMsg((Properties)Env.getCtx(), (String)"Script"), null, 0);
    }

    public GroovyEditor(String title, String script, int WindowNo) {
        this(null, title, script, WindowNo);
    }

    public GroovyEditor(Frame owner, String title, String script, int WindowNo) {
        super(owner);
        this.setTitle(title);
        if (owner != null) {
            this.setModal(true);
        }
        this.m_owner = owner;
        this.m_WindowNo = WindowNo;
        if (this.m_WindowNo == 0) {
            this.m_WindowNo = AEnv.createWindowNo(this);
        }
        if (log.isLoggable(Level.INFO)) {
            log.info("Window=" + this.m_WindowNo);
        }
        try {
            this.jbInit();
            this.setScript(script);
            this.dynInit();
            AEnv.showCenterScreen(this);
            this.toFront();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "", (Throwable)ex);
        }
    }

    void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.titledBorder2 = new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140)), Msg.getMsg((Properties)Env.getCtx(), (String)"ScriptEditor"));
        this.mainPanel.setLayout(this.borderLayout1);
        this.bOK.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.bProcess.addActionListener(this);
        this.bHelp.addActionListener(this);
        this.editorPane.setBorder(this.titledBorder2);
        this.editorPane.setPreferredSize(new Dimension(500, 500));
        this.southPanel.setLayout(this.southLayout);
        this.resultPanel.setLayout(this.resultLayout);
        this.lResult.setText(Msg.getMsg((Properties)Env.getCtx(), (String)"ScriptResult"));
        this.fResult.setBackground(Color.lightGray);
        this.fResult.setEditable(false);
        this.fResult.setText("");
        this.okPanel.setLayout(this.okLayout);
        this.getContentPane().add(this.mainPanel);
        this.editorPane.getViewport().add((Component)this.editor, null);
        this.mainPanel.add((Component)this.southPanel, "South");
        this.southPanel.add((Component)this.okPanel, "East");
        this.okPanel.add((Component)this.bCancel, null);
        this.okPanel.add((Component)this.bOK, null);
        this.southPanel.add((Component)this.resultPanel, "Center");
        this.resultPanel.add((Component)this.bProcess, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resultPanel.add((Component)this.lResult, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.resultPanel.add((Component)this.fResult, new GridBagConstraints(2, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.resultPanel.add((Component)this.bHelp, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.editorPane, "Center");
    }

    public void setScript(String script) {
        this.m_script = script == null ? "" : script;
        this.m_origScript = this.m_script;
        this.editor.getTextEditor().setText(this.m_script);
    }

    private void dynInit() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bOK) {
            this.m_script = this.editor.getTextEditor().getText();
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.m_script = this.m_origScript;
            this.dispose();
        } else if (e.getSource() == this.bProcess) {
            this.actionProcess();
        } else if (e.getSource() == this.bHelp) {
            Help h = new Help(this, Msg.getMsg((Properties)Env.getCtx(), (String)"ScriptHelp"), this.getClass().getResource("Script.html"));
            h.setVisible(true);
        }
    }

    private void actionProcess() {
        MUser user = MUser.get((Properties)Env.getCtx());
        if (!user.isAdministrator()) {
            this.fResult.setText("Not Administrator");
            return;
        }
        GroovyShell sh = new GroovyShell();
        Exception e = null;
        try {
            sh.parse(this.editor.getTextEditor().getText());
        }
        catch (Exception e1) {
            e = e1;
        }
        if (e != null) {
            ADialog.error(this.m_WindowNo, this, "ScriptError", e.toString());
            this.fResult.setText("Syntax errors detected.");
        } else {
            this.fResult.setText("No syntax errors detected.");
        }
    }

    public static String start(Frame owner, String header, String script, boolean editable, int WindowNo) {
        GroovyEditor se = new GroovyEditor(owner, header, script, WindowNo);
        return se.getScript();
    }

    public String getScript() {
        return this.m_script;
    }
}

