/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.client;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import org.adempiere.client.Application;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.util.RestletUtil;
import org.compiere.db.CConnection;
import org.compiere.db.SecurityPrincipal;
import org.compiere.interfaces.Server;
import org.compiere.process.ProcessInfo;
import org.compiere.util.EMail;
import org.restlet.Context;
import org.restlet.data.ChallengeResponse;
import org.restlet.data.ChallengeScheme;
import org.restlet.representation.ObjectRepresentation;
import org.restlet.representation.Representation;
import org.restlet.resource.ClientResource;

public class ServerInterface
implements Server {
    private ClientResource createClientResource(URI uri) {
        Context context = this.getContext();
        ClientResource resource = new ClientResource(context, uri);
        resource.setChallengeResponse(this.createChallengeResponse());
        return resource;
    }

    private ChallengeResponse createChallengeResponse() {
        SecurityPrincipal principal = CConnection.get().getAppServerCredential();
        ChallengeResponse cr = new ChallengeResponse(ChallengeScheme.HTTP_BASIC, principal.identity, principal.secret);
        return cr;
    }

    private Context getContext() {
        return Application.context;
    }

    public String postImmediate(Properties ctx, int AD_Client_ID, int AD_Table_ID, int Record_ID, boolean force) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("context", ctx);
        map.put("AD_Table_ID", Integer.valueOf(AD_Table_ID));
        map.put("Record_ID", Integer.valueOf(Record_ID));
        map.put("force", Boolean.valueOf(force));
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/postDocument", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public ProcessInfo process(Properties ctx, ProcessInfo pi) {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        map.put("context", ctx);
        map.put("processInfo", (Properties)pi);
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/executeProcess", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            ProcessInfo responseInfo = (ProcessInfo)RestletUtil.toObject((Representation)response);
            return responseInfo;
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public ProcessInfo workflow(Properties ctx, ProcessInfo pi, int AD_Workflow_ID) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("context", ctx);
        map.put("AD_Workflow_ID", Integer.valueOf(AD_Workflow_ID));
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/executeWorkflow", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            ProcessInfo responseInfo = (ProcessInfo)RestletUtil.toObject((Representation)response);
            return responseInfo;
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String sendEMail(Properties ctx, EMail email) {
        HashMap<String, Properties> map = new HashMap<String, Properties>();
        map.put("context", ctx);
        map.put("email", (Properties)email);
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/sendEmail", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public String executeTask(Properties ctx, int AD_Task_ID) {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("context", ctx);
        map.put("AD_Task_ID", Integer.valueOf(AD_Task_ID));
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/executeTask", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            return response != null ? response.getText() : "";
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public int cacheReset(Properties ctx, String tableName, int Record_ID) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", ctx);
        map.put("tableName", tableName);
        map.put("Record_ID", Record_ID);
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/resetCache", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            return response != null ? Integer.parseInt(response.getText()) : 0;
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }

    public ProcessInfo dbProcess(Properties ctx, ProcessInfo processInfo, String procedureName) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("context", ctx);
        map.put("processInfo", processInfo);
        map.put("procedureName", procedureName);
        try {
            URI uri = new URI("https", null, CConnection.get().getAppsHost(), CConnection.get().getSSLPort(), "/server/command/executeProcess", null, null);
            ClientResource resource = this.createClientResource(uri);
            ObjectRepresentation entity = new ObjectRepresentation(map);
            Representation response = resource.post((Representation)entity);
            ProcessInfo responseInfo = (ProcessInfo)RestletUtil.toObject((Representation)response);
            return responseInfo;
        }
        catch (Exception e) {
            throw new AdempiereException((Throwable)e);
        }
    }
}

