/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.examples;

import java.io.File;
import org.jpedal.PdfDecoder;
import org.jpedal.objects.PdfFileInformation;

public class ShowDocumentProperties {
    private String user_dir = System.getProperty("user.dir");
    private static String test_file = "/mnt/win_d/sample.pdf";

    public ShowDocumentProperties(String string) {
        String string2 = System.getProperty("file.separator");
        if (!this.user_dir.endsWith(string2)) {
            this.user_dir = this.user_dir + string2;
        }
        PdfDecoder pdfDecoder = null;
        try {
            pdfDecoder = new PdfDecoder(false);
            System.out.println("Opening file :" + string);
            pdfDecoder.openPdfFile(string);
        }
        catch (Exception exception) {
            System.err.println("Exception " + exception + " in pdf code");
        }
        if (pdfDecoder.isEncrypted() && !pdfDecoder.isExtractionAllowed()) {
            System.out.println("Encrypted settings");
            System.out.println("Please look at SimpleViewer for code sample to handle such files");
            System.out.println("Or get support/consultancy");
        }
        PdfFileInformation pdfFileInformation = pdfDecoder.getFileInformationData();
        String[] stringArray = pdfFileInformation.getFieldValues();
        String[] stringArray2 = pdfFileInformation.getFieldNames();
        int n = stringArray2.length;
        System.out.println("Fields");
        System.out.println("======");
        for (int i = 0; i < n; ++i) {
            System.out.println(stringArray2[i] + " = " + stringArray[i]);
        }
        System.out.println("\nMetadata");
        System.out.println("======");
        System.out.println(pdfFileInformation.getFileXMLMetaData());
        pdfDecoder.closePdfFile();
    }

    public static void main(String[] stringArray) {
        System.out.println("Simple demo to extract pdf file properties");
        String string = test_file;
        if (stringArray.length != 1) {
            System.out.println("Default test file used");
        } else {
            string = stringArray[0];
            System.out.println("File :" + string);
        }
        File file = new File(string);
        if (!file.exists()) {
            System.out.println("File " + string + " not found");
        }
        ShowDocumentProperties showDocumentProperties = new ShowDocumentProperties(string);
    }
}

