/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.util.HashSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class RollUpCosts
extends SvrProcess {
    int category = 0;
    int product_id = 0;
    int client_id = 0;
    int costelement_id = 0;
    private HashSet<Integer> processed;

    protected void prepare() {
        int chosen_id = 0;
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if (para[i].getParameter() != null) {
                if (name.equals("M_Product_Category_ID")) {
                    this.category = para[i].getParameterAsInt();
                } else if (name.equals("M_Product_ID")) {
                    chosen_id = para[i].getParameterAsInt();
                } else if (name.equals("M_CostElement_ID")) {
                    this.costelement_id = para[i].getParameterAsInt();
                } else {
                    this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
                }
            }
            ++i;
        }
        this.product_id = this.getRecord_ID();
        if (this.product_id == 0) {
            this.product_id = chosen_id;
        }
    }

    protected String doIt() throws Exception {
        this.client_id = Env.getAD_Client_ID((Properties)this.getCtx());
        this.createArray();
        String result = this.rollUp();
        return result;
    }

    protected String rollUp() throws Exception {
        if (this.product_id != 0) {
            this.rollUpCosts(this.product_id);
        } else if (this.category != 0) {
            int[] prodids;
            String sql = "SELECT M_Product_ID FROM M_Product WHERE M_Product_Category_ID = ? AND AD_Client_ID = ?  AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product_BOM)";
            int[] nArray = prodids = DB.getIDsEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.category, this.client_id});
            int n = prodids.length;
            int n2 = 0;
            while (n2 < n) {
                int prodid = nArray[n2];
                this.rollUpCosts(prodid);
                ++n2;
            }
        } else {
            int[] prodids;
            String sql = "SELECT M_Product_ID FROM M_Product WHERE AD_Client_ID = ?  AND M_Product_ID IN (SELECT M_Product_ID FROM M_Product_BOM)";
            int[] nArray = prodids = DB.getIDsEx((String)this.get_TrxName(), (String)sql, (Object[])new Object[]{this.client_id});
            int n = prodids.length;
            int n3 = 0;
            while (n3 < n) {
                int prodid = nArray[n3];
                this.rollUpCosts(prodid);
                ++n3;
            }
        }
        return "Roll Up Complete";
    }

    protected void createArray() throws Exception {
        this.processed = new HashSet();
    }

    protected void rollUpCosts(int p_id) throws Exception {
        int[] prodbomids;
        StringBuilder sql = new StringBuilder("SELECT M_ProductBOM_ID FROM M_Product_BOM WHERE M_Product_ID = ? ").append(" AND AD_Client_ID = ").append(this.client_id);
        int[] nArray = prodbomids = DB.getIDsEx((String)this.get_TrxName(), (String)sql.toString(), (Object[])new Object[]{this.client_id});
        int n = prodbomids.length;
        int n2 = 0;
        while (n2 < n) {
            int prodbomid = nArray[n2];
            if (!this.processed.contains(p_id)) {
                this.rollUpCosts(prodbomid);
            }
            ++n2;
        }
        StringBuilder update = new StringBuilder("UPDATE M_Cost set CurrentCostPrice = COALESCE((select Sum (b.BOMQty * c.currentcostprice)").append(" FROM M_Product_BOM b INNER JOIN M_Cost c ON (b.M_PRODUCTBOM_ID = c.M_Product_ID) ").append(" WHERE b.M_Product_ID = ").append(p_id).append(" AND M_CostElement_ID = ").append(this.costelement_id).append("),0),").append(" FutureCostPrice = COALESCE((select Sum (b.BOMQty * c.futurecostprice) FROM M_Product_BOM b ").append(" INNER JOIN M_Cost c ON (b.M_PRODUCTBOM_ID = c.M_Product_ID) ").append(" WHERE b.M_Product_ID = ").append(p_id).append(" AND M_CostElement_ID = ").append(this.costelement_id).append("),0)").append(" WHERE M_Product_ID = ").append(p_id).append(" AND AD_Client_ID = ").append(this.client_id).append(" AND M_CostElement_ID = ").append(this.costelement_id).append(" AND M_PRODUCT_ID IN (SELECT M_PRODUCT_ID FROM M_PRODUCT_BOM)");
        DB.executeUpdate((String)update.toString(), (String)this.get_TrxName());
        this.processed.add(p_id);
    }
}

