/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import java.math.BigDecimal;
import java.util.logging.Level;
import org.compiere.model.MProduction;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.AdempiereUserError;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductionCreate
extends SvrProcess {
    private int p_M_Production_ID = 0;
    private MProduction m_production = null;
    private boolean mustBeStocked = false;
    private boolean recreate = false;
    private BigDecimal newQty = null;

    protected void prepare() {
        ProcessInfoParameter[] para = this.getParameter();
        int i = 0;
        while (i < para.length) {
            String name = para[i].getParameterName();
            if ("Recreate".equals(name)) {
                this.recreate = "Y".equals(para[i].getParameter());
            } else if ("ProductionQty".equals(name)) {
                this.newQty = (BigDecimal)para[i].getParameter();
            } else {
                this.log.log(Level.SEVERE, "Unknown Parameter: " + name);
            }
            ++i;
        }
        this.p_M_Production_ID = this.getRecord_ID();
        this.m_production = new MProduction(this.getCtx(), this.p_M_Production_ID, this.get_TrxName());
    }

    protected String doIt() throws Exception {
        if (this.m_production.get_ID() == 0) {
            throw new AdempiereUserError("Could not load production header");
        }
        if (this.m_production.isProcessed()) {
            return "Already processed";
        }
        return this.createLines();
    }

    private boolean costsOK(int M_Product_ID) throws AdempiereUserError {
        String sql = "SELECT ABS(((cc.currentcostprice-(SELECT SUM(c.currentcostprice*bom.bomqty) FROM m_cost c INNER JOIN m_product_bom bom ON (c.m_product_id=bom.m_productbom_id) INNER JOIN m_costelement ce ON (c.m_costelement_id = ce.m_costelement_id AND ce.costingmethod = 'S') WHERE bom.m_product_id = pp.m_product_id) )/cc.currentcostprice)) FROM m_product pp INNER JOIN m_cost cc on (cc.m_product_id=pp.m_product_id) INNER JOIN m_costelement ce ON (cc.m_costelement_id=ce.m_costelement_id) WHERE cc.currentcostprice > 0 AND pp.M_Product_ID = ? AND ce.costingmethod='S'";
        BigDecimal costPercentageDiff = DB.getSQLValueBD((String)this.get_TrxName(), (String)sql, (int)M_Product_ID);
        if (costPercentageDiff == null) {
            costPercentageDiff = Env.ZERO;
            String msg = "Could not retrieve costs";
            if (MSysConfig.getBooleanValue((String)"MFG_ValidateCostsOnCreate", (boolean)false, (int)this.getAD_Client_ID())) {
                throw new AdempiereUserError(msg);
            }
            this.log.warning(msg);
        }
        return costPercentageDiff.compareTo(new BigDecimal("0.005")) < 0;
    }

    protected String createLines() throws Exception {
        int created = 0;
        this.isBom(this.m_production.getM_Product_ID());
        if (!this.costsOK(this.m_production.getM_Product_ID())) {
            String msg = "Excessive difference in standard costs";
            if (MSysConfig.getBooleanValue((String)"MFG_ValidateCostsDifferenceOnCreate", (boolean)false, (int)this.getAD_Client_ID())) {
                throw new AdempiereUserError("Excessive difference in standard costs");
            }
            this.log.warning(msg);
        }
        if (!this.recreate && "Y".equalsIgnoreCase(this.m_production.getIsCreated())) {
            throw new AdempiereUserError("Production already created.");
        }
        if (this.newQty != null) {
            this.m_production.setProductionQty(this.newQty);
        }
        this.m_production.deleteLines(this.get_TrxName());
        created = this.m_production.createLines(this.mustBeStocked);
        if (created == 0) {
            return "Failed to create production lines";
        }
        this.m_production.setIsCreated("Y");
        this.m_production.save(this.get_TrxName());
        StringBuilder msgreturn = new StringBuilder().append(created).append(" production lines were created");
        return msgreturn.toString();
    }

    protected void isBom(int M_Product_ID) throws Exception {
        String bom = DB.getSQLValueString((String)this.get_TrxName(), (String)"SELECT isbom FROM M_Product WHERE M_Product_ID = ?", (int)M_Product_ID);
        if ("N".compareTo(bom) == 0) {
            throw new AdempiereUserError("Attempt to create product line for Non Bill Of Materials");
        }
        int materials = DB.getSQLValue((String)this.get_TrxName(), (String)"SELECT count(M_Product_BOM_ID) FROM M_Product_BOM WHERE M_Product_ID = ?", (int)M_Product_ID);
        if (materials == 0) {
            throw new AdempiereUserError("Attempt to create product line for Bill Of Materials with no BOM Products");
        }
    }
}

